/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDPageLabels;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDURIDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThread;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;

public class PDDocumentCatalog
implements COSObjectable {
    private COSDictionary root;
    private PDDocument document;
    private PDAcroForm acroForm = null;
    public static final String PAGE_MODE_USE_NONE = "UseNone";
    public static final String PAGE_MODE_USE_OUTLINES = "UseOutlines";
    public static final String PAGE_MODE_USE_THUMBS = "UseThumbs";
    public static final String PAGE_MODE_FULL_SCREEN = "FullScreen";
    public static final String PAGE_MODE_USE_OPTIONAL_CONTENT = "UseOC";
    public static final String PAGE_MODE_USE_ATTACHMENTS = "UseAttachments";
    public static final String PAGE_LAYOUT_SINGLE_PAGE = "SinglePage";
    public static final String PAGE_LAYOUT_ONE_COLUMN = "OneColumn";
    public static final String PAGE_LAYOUT_TWO_COLUMN_LEFT = "TwoColumnLeft";
    public static final String PAGE_LAYOUT_TWO_COLUMN_RIGHT = "TwoColumnRight";
    public static final String PAGE_LAYOUT_TWO_PAGE_LEFT = "TwoPageLeft";
    public static final String PAGE_LAYOUT_TWO_PAGE_RIGHT = "TwoPageRight";

    public PDDocumentCatalog(PDDocument doc) {
        this.document = doc;
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)new COSString("Catalog"));
        this.document.getDocument().getTrailer().setItem(COSName.ROOT, (COSBase)this.root);
    }

    public PDDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    public COSBase getCOSObject() {
        return this.root;
    }

    public COSDictionary getCOSDictionary() {
        return this.root;
    }

    public PDAcroForm getAcroForm() {
        COSDictionary acroFormDic;
        if (this.acroForm == null && (acroFormDic = (COSDictionary)this.root.getDictionaryObject(COSName.ACRO_FORM)) != null) {
            this.acroForm = new PDAcroForm(this.document, acroFormDic);
        }
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm acro) {
        this.root.setItem(COSName.ACRO_FORM, (COSObjectable)acro);
    }

    public PDPageNode getPages() {
        return new PDPageNode((COSDictionary)this.root.getDictionaryObject(COSName.PAGES));
    }

    public List getAllPages() {
        ArrayList retval = new ArrayList();
        PDPageNode rootNode = this.getPages();
        rootNode.getAllKids(retval);
        return retval;
    }

    public PDViewerPreferences getViewerPreferences() {
        PDViewerPreferences retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject(COSName.VIEWER_PREFERENCES);
        if (dict != null) {
            retval = new PDViewerPreferences(dict);
        }
        return retval;
    }

    public void setViewerPreferences(PDViewerPreferences prefs) {
        this.root.setItem(COSName.VIEWER_PREFERENCES, (COSObjectable)prefs);
    }

    public PDDocumentOutline getDocumentOutline() {
        PDDocumentOutline retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject(COSName.OUTLINES);
        if (dict != null) {
            retval = new PDDocumentOutline(dict);
        }
        return retval;
    }

    public void setDocumentOutline(PDDocumentOutline outlines) {
        this.root.setItem(COSName.OUTLINES, (COSObjectable)outlines);
    }

    public List getThreads() {
        COSArray array = (COSArray)this.root.getDictionaryObject(COSName.THREADS);
        if (array == null) {
            array = new COSArray();
            this.root.setItem(COSName.THREADS, (COSBase)array);
        }
        ArrayList<PDThread> pdObjects = new ArrayList<PDThread>();
        for (int i = 0; i < array.size(); ++i) {
            pdObjects.add(new PDThread((COSDictionary)array.getObject(i)));
        }
        return new COSArrayList(pdObjects, array);
    }

    public void setThreads(List threads) {
        this.root.setItem(COSName.THREADS, (COSBase)COSArrayList.converterToCOSArray(threads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.root.getDictionaryObject(COSName.METADATA);
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.root.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public void setOpenAction(PDDestinationOrAction action) {
        this.root.setItem(COSName.OPEN_ACTION, (COSObjectable)action);
    }

    public PDDestinationOrAction getOpenAction() throws IOException {
        PDDestinationOrAction action = null;
        COSBase actionObj = this.root.getDictionaryObject(COSName.OPEN_ACTION);
        if (actionObj != null) {
            if (actionObj instanceof COSDictionary) {
                action = PDActionFactory.createAction((COSDictionary)actionObj);
            } else if (actionObj instanceof COSArray) {
                action = PDDestination.create(actionObj);
            } else {
                throw new IOException("Unknown OpenAction " + actionObj);
            }
        }
        return action;
    }

    public PDDocumentCatalogAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.root.getDictionaryObject(COSName.AA);
        if (addAct == null) {
            addAct = new COSDictionary();
            this.root.setItem(COSName.AA, (COSBase)addAct);
        }
        return new PDDocumentCatalogAdditionalActions(addAct);
    }

    public void setActions(PDDocumentCatalogAdditionalActions actions) {
        this.root.setItem(COSName.AA, (COSObjectable)actions);
    }

    public PDDocumentNameDictionary getNames() {
        PDDocumentNameDictionary nameDic = null;
        COSDictionary names = (COSDictionary)this.root.getDictionaryObject(COSName.NAMES);
        if (names != null) {
            nameDic = new PDDocumentNameDictionary(this, names);
        }
        return nameDic;
    }

    public void setNames(PDDocumentNameDictionary names) {
        this.root.setItem(COSName.NAMES, (COSObjectable)names);
    }

    public PDMarkInfo getMarkInfo() {
        PDMarkInfo retval = null;
        COSDictionary dic = (COSDictionary)this.root.getDictionaryObject(COSName.MARK_INFO);
        if (dic != null) {
            retval = new PDMarkInfo(dic);
        }
        return retval;
    }

    public void setMarkInfo(PDMarkInfo markInfo) {
        this.root.setItem(COSName.MARK_INFO, (COSObjectable)markInfo);
    }

    public String getPageMode() {
        return this.root.getNameAsString(COSName.PAGE_MODE, PAGE_MODE_USE_NONE);
    }

    public void setPageMode(String mode) {
        this.root.setName(COSName.PAGE_MODE, mode);
    }

    public String getPageLayout() {
        return this.root.getNameAsString(COSName.PAGE_LAYOUT, PAGE_LAYOUT_SINGLE_PAGE);
    }

    public void setPageLayout(String layout) {
        this.root.setName(COSName.PAGE_LAYOUT, layout);
    }

    public PDURIDictionary getURI() {
        PDURIDictionary retval = null;
        COSDictionary uri = (COSDictionary)this.root.getDictionaryObject(COSName.URI);
        if (uri != null) {
            retval = new PDURIDictionary(uri);
        }
        return retval;
    }

    public void setURI(PDURIDictionary uri) {
        this.root.setItem(COSName.URI, (COSObjectable)uri);
    }

    public PDStructureTreeRoot getStructureTreeRoot() {
        PDStructureTreeRoot treeRoot = null;
        COSDictionary dic = (COSDictionary)this.root.getDictionaryObject(COSName.STRUCT_TREE_ROOT);
        if (dic != null) {
            treeRoot = new PDStructureTreeRoot(dic);
        }
        return treeRoot;
    }

    public void setStructureTreeRoot(PDStructureTreeRoot treeRoot) {
        this.root.setItem(COSName.STRUCT_TREE_ROOT, (COSObjectable)treeRoot);
    }

    public String getLanguage() {
        return this.root.getString(COSName.LANG);
    }

    public void setLanguage(String language) {
        this.root.setString(COSName.LANG, language);
    }

    public PDPageLabels getPageLabels() throws IOException {
        PDPageLabels labels = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject(COSName.PAGE_LABELS);
        if (dict != null) {
            labels = new PDPageLabels(this.document, dict);
        }
        return labels;
    }

    public void setPageLabels(PDPageLabels labels) {
        this.root.setItem(COSName.PAGE_LABELS, (COSObjectable)labels);
    }
}

