/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableDouble;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicCounter<E>
implements Serializable,
Counter<E>,
Iterable<E> {
    Map<E, MutableDouble> map;
    private MapFactory<E, MutableDouble> mapFactory;
    private double totalCount;
    private double defaultValue;
    private static final long serialVersionUID = 4L;
    private transient MutableDouble tempMDouble;

    public ClassicCounter() {
        this(MapFactory.hashMapFactory());
    }

    public ClassicCounter(MapFactory<E, MutableDouble> mapFactory) {
        this.mapFactory = mapFactory;
        this.map = mapFactory.newMap();
    }

    public ClassicCounter(Counter<E> c) {
        this();
        Counters.addInPlace(this, c);
        this.setDefaultReturnValue(c.defaultReturnValue());
    }

    public ClassicCounter(Collection<E> collection) {
        this();
        for (E key : collection) {
            this.incrementCount(key);
        }
    }

    MapFactory<E, MutableDouble> getMapFactory() {
        return this.mapFactory;
    }

    @Override
    public Factory<Counter<E>> getFactory() {
        return new ClassicCounterFactory(this.getMapFactory());
    }

    @Override
    public final void setDefaultReturnValue(double rv) {
        this.defaultValue = rv;
    }

    @Override
    public double defaultReturnValue() {
        return this.defaultValue;
    }

    @Override
    public double getCount(E key) {
        Number count = this.map.get(key);
        if (count == null) {
            return this.defaultValue;
        }
        return count.doubleValue();
    }

    @Override
    public void setCount(E key, double count) {
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        this.tempMDouble.set(count);
        this.tempMDouble = this.map.put(key, this.tempMDouble);
        this.totalCount += count;
        if (this.tempMDouble != null) {
            this.totalCount -= this.tempMDouble.doubleValue();
        }
    }

    @Override
    public double incrementCount(E key, double count) {
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        MutableDouble oldMDouble = this.map.put(key, this.tempMDouble);
        this.totalCount += count;
        if (oldMDouble != null) {
            count += oldMDouble.doubleValue();
        }
        this.tempMDouble.set(count);
        this.tempMDouble = oldMDouble;
        return count;
    }

    @Override
    public final double incrementCount(E key) {
        return this.incrementCount(key, 1.0);
    }

    @Override
    public double decrementCount(E key, double count) {
        return this.incrementCount(key, -count);
    }

    @Override
    public double decrementCount(E key) {
        return this.incrementCount(key, -1.0);
    }

    @Override
    public double logIncrementCount(E key, double count) {
        MutableDouble oldMDouble;
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        if ((oldMDouble = this.map.put(key, this.tempMDouble)) != null) {
            count = SloppyMath.logAdd(count, oldMDouble.doubleValue());
            this.totalCount += count - oldMDouble.doubleValue();
        } else {
            this.totalCount += count;
        }
        this.tempMDouble.set(count);
        this.tempMDouble = oldMDouble;
        return count;
    }

    @Override
    public void addAll(Counter<E> counter) {
        Counters.addInPlace(this, counter);
    }

    @Override
    public double remove(E key) {
        MutableDouble d = this.mutableRemove(key);
        if (d != null) {
            return d.doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public boolean containsKey(E key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Double> values() {
        return new AbstractCollection<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){
                    Iterator<MutableDouble> inner;
                    {
                        this.inner = ClassicCounter.this.map.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public Double next() {
                        return this.inner.next().doubleValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ClassicCounter.this.map.size();
            }

            @Override
            public boolean contains(Object v) {
                return v instanceof Double && ClassicCounter.this.map.values().contains(new MutableDouble((Double)v));
            }
        };
    }

    @Override
    public Set<Map.Entry<E, Double>> entrySet() {
        return new AbstractSet<Map.Entry<E, Double>>(){

            @Override
            public Iterator<Map.Entry<E, Double>> iterator() {
                return new Iterator<Map.Entry<E, Double>>(){
                    final Iterator<Map.Entry<E, MutableDouble>> inner;
                    {
                        this.inner = ClassicCounter.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public Map.Entry<E, Double> next() {
                        return new Map.Entry<E, Double>(){
                            final Map.Entry<E, MutableDouble> e;
                            {
                                this.e = inner.next();
                            }

                            public double getDoubleValue() {
                                return this.e.getValue().doubleValue();
                            }

                            @Override
                            public double setValue(double value) {
                                double old = this.e.getValue().doubleValue();
                                this.e.getValue().set(value);
                                ClassicCounter.this.totalCount = ClassicCounter.this.totalCount - old + value;
                                return old;
                            }

                            @Override
                            public E getKey() {
                                return this.e.getKey();
                            }

                            @Override
                            public Double getValue() {
                                return this.getDoubleValue();
                            }

                            @Override
                            public Double setValue(Double value) {
                                return this.setValue((double)value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ClassicCounter.this.map.size();
            }
        };
    }

    @Override
    public void clear() {
        this.map.clear();
        this.totalCount = 0.0;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public double totalCount() {
        return this.totalCount;
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet().iterator();
    }

    private MutableDouble mutableRemove(E key) {
        MutableDouble md = this.map.remove(key);
        if (md != null) {
            this.totalCount -= md.doubleValue();
        }
        return md;
    }

    public void removeAll(Collection<E> keys) {
        for (E key : keys) {
            this.mutableRemove(key);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Counter)) {
            return false;
        }
        if (!(o instanceof ClassicCounter)) {
            return Counters.equals(this, (Counter)o);
        }
        ClassicCounter counter = (ClassicCounter)o;
        return this.totalCount == counter.totalCount && ((Object)this.map).equals(counter.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public static ClassicCounter<String> valueOfIgnoreComments(String s) {
        String[] lines;
        ClassicCounter<String> result = new ClassicCounter<String>();
        for (String line : lines = s.split("\n")) {
            String[] fields = line.split("\t");
            if (fields.length != 2) {
                if (line.startsWith("#")) continue;
                throw new RuntimeException("Got unsplittable line: \"" + line + '\"');
            }
            result.setCount(fields[0], Double.parseDouble(fields[1]));
        }
        return result;
    }

    public static ClassicCounter<String> fromString(String s) {
        String[] lines;
        ClassicCounter<String> result = new ClassicCounter<String>();
        if (!s.startsWith("{") || !s.endsWith("}")) {
            throw new RuntimeException("invalid format: ||" + s + "||");
        }
        s = s.substring(1, s.length() - 1);
        for (String line : lines = s.split(", ")) {
            String[] fields = line.split("=");
            if (fields.length != 2) {
                throw new RuntimeException("Got unsplittable line: \"" + line + '\"');
            }
            result.setCount(fields[0], Double.parseDouble(fields[1]));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassicCounterFactory<E>
    implements Factory<Counter<E>> {
        private static final long serialVersionUID = 1L;
        private final MapFactory<E, MutableDouble> mf;

        private ClassicCounterFactory(MapFactory<E, MutableDouble> mf) {
            this.mf = mf;
        }

        @Override
        public Counter<E> create() {
            return new ClassicCounter<E>(this.mf);
        }
    }
}

