# Generated by default/object.tt
package Paws::ImageBuilder::Schedule;
  use Moose;
  has PipelineExecutionStartCondition => (is => 'ro', isa => 'Str', request_name => 'pipelineExecutionStartCondition', traits => ['NameInRequest']);
  has ScheduleExpression => (is => 'ro', isa => 'Str', request_name => 'scheduleExpression', traits => ['NameInRequest']);
  has Timezone => (is => 'ro', isa => 'Str', request_name => 'timezone', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::Schedule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::Schedule object:

  $service_obj->Method(Att1 => { PipelineExecutionStartCondition => $value, ..., Timezone => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::Schedule object:

  $result = $service_obj->Method(...);
  $result->Att1->PipelineExecutionStartCondition

=head1 DESCRIPTION

A schedule configures how often and when a pipeline will automatically
create a new image.

=head1 ATTRIBUTES


=head2 PipelineExecutionStartCondition => Str

The condition configures when the pipeline should trigger a new image
build. When the C<pipelineExecutionStartCondition> is set to
C<EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE>, and you use
semantic version filters on the source image or components in your
image recipe, EC2 Image Builder will build a new image only when there
are new versions of the image or components in your recipe that match
the semantic version filter. When it is set to
C<EXPRESSION_MATCH_ONLY>, it will build a new image every time the CRON
expression matches the current time. For semantic version syntax, see
CreateComponent
(https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html)
in the I< EC2 Image Builder API Reference>.


=head2 ScheduleExpression => Str

The cron expression determines how often EC2 Image Builder evaluates
your C<pipelineExecutionStartCondition>.

For information on how to format a cron expression in Image Builder,
see Use cron expressions in EC2 Image Builder
(https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html).


=head2 Timezone => Str

The timezone that applies to the scheduling expression. For example,
"Etc/UTC", "America/Los_Angeles" in the IANA timezone format
(https://www.joda.org/joda-time/timezones.html). If not specified this
defaults to UTC.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

