/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap;

import at.ac.tuwien.dbai.pdfwrap.ProcessFile;
import at.ac.tuwien.dbai.pdfwrap.analysis.PageProcessor;
import at.ac.tuwien.dbai.pdfwrap.comparators.XComparator;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.Page;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyGraph;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocNode;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocumentGraph;
import at.ac.tuwien.dbai.pdfwrap.model.graph.WrappingInstance;
import at.ac.tuwien.dbai.pdfwrap.pdfread.PDFObjectExtractor;
import at.ac.tuwien.dbai.pdfwrap.utils.ListUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GraphMatcher {
    protected static List<DocNode> getNeighboursFrom(DocNode node, List<DocEdge> docEdges, List<DocEdge> edgesToReturn) {
        ArrayList<DocNode> retVal = new ArrayList<DocNode>();
        for (DocEdge e : docEdges) {
            if (e.getFrom() != node) continue;
            retVal.add(e.getTo());
            edgesToReturn.add(e);
        }
        return retVal;
    }

    protected static List<DocNode> getNeighboursTo(DocNode node, List<DocEdge> docEdges, List<DocEdge> edgesToReturn) {
        ArrayList<DocNode> retVal = new ArrayList<DocNode>();
        for (DocEdge e : docEdges) {
            if (e.getTo() != node) continue;
            retVal.add(e.getFrom());
            edgesToReturn.add(e);
        }
        return retVal;
    }

    protected static boolean corresponds(DocNode insN, DocNode docN, boolean[][] M, List<DocNode> instanceNodes, List<DocNode> documentNodes) {
        int insNIndex = -1;
        int currIndex = -1;
        Iterator<DocNode> insNodesIter = instanceNodes.iterator();
        while (insNodesIter.hasNext() && insNIndex == -1) {
            ++currIndex;
            DocNode nextObj = insNodesIter.next();
            if (nextObj != insN) continue;
            insNIndex = currIndex;
        }
        int docNIndex = -1;
        currIndex = -1;
        Iterator<DocNode> docNodesIter = documentNodes.iterator();
        while (docNodesIter.hasNext() && docNIndex == -1) {
            ++currIndex;
            DocNode nextObj = docNodesIter.next();
            if (nextObj != docN) continue;
            docNIndex = currIndex;
        }
        return M[insNIndex][docNIndex];
    }

    protected static DocNode getCorrespondingNode(DocNode insN, boolean[][] M, List<DocNode> instanceNodes, List<DocNode> documentNodes) {
        int insNIndex = -1;
        int currIndex = -1;
        Iterator<DocNode> insNodesIter = instanceNodes.iterator();
        while (insNodesIter.hasNext() && insNIndex == -1) {
            ++currIndex;
            DocNode nextObj = insNodesIter.next();
            if (nextObj != insN) continue;
            insNIndex = currIndex;
        }
        int x = -1;
        int n = 0;
        while (n < M[insNIndex].length) {
            if (M[insNIndex][n]) {
                x = n;
                n = M[insNIndex].length;
            }
            ++n;
        }
        return documentNodes.get(x);
    }

    protected static List<DocNode> getCorrespondingNodes(DocNode insN, boolean[][] M, List<DocNode> instanceNodes, List<DocNode> documentNodes) {
        ArrayList<DocNode> retVal = new ArrayList<DocNode>();
        int insNIndex = -1;
        int currIndex = -1;
        Iterator<DocNode> insNodesIter = instanceNodes.iterator();
        while (insNodesIter.hasNext() && insNIndex == -1) {
            ++currIndex;
            DocNode nextObj = insNodesIter.next();
            if (nextObj != insN) continue;
            insNIndex = currIndex;
        }
        int n = 0;
        while (n < M[insNIndex].length) {
            if (M[insNIndex][n]) {
                retVal.add(documentNodes.get(n));
            }
            ++n;
        }
        return retVal;
    }

    protected static boolean existsMatchNPath(DocNode insNodeFrom, DocNode insNodeTo, DocNode docNodeFrom, DocNode docNodeTo, DocEdge matchNEdge, List<DocEdge> documentEdges) {
        DocNode currentNode = docNodeFrom;
        boolean switched = false;
        boolean loop = true;
        while (loop) {
            ArrayList<DocEdge> edgeList = new ArrayList<DocEdge>();
            List<DocNode> neighbours = GraphMatcher.getNeighboursFrom(currentNode, documentEdges, edgeList);
            boolean foundNeighbour = false;
            int n = 0;
            while (n < edgeList.size()) {
                DocEdge edge = (DocEdge)edgeList.get(n);
                if (GraphMatcher.compareEdges(matchNEdge, edge)) {
                    DocNode neighbour = neighbours.get(n);
                    boolean nodeOK = true;
                    if (matchNEdge.getMultipleMatch() == DocEdge.MATCH_N_TIL_LAST) {
                        if (!GraphMatcher.compareNodes(insNodeFrom, neighbour)) {
                            switched = true;
                        }
                        if (switched & !GraphMatcher.compareNodes(insNodeTo, neighbour)) {
                            nodeOK = false;
                        }
                    }
                    if (nodeOK) {
                        if (matchNEdge.getMultipleMatch() == DocEdge.MATCH_N_TIL_FIRST) {
                            if (currentNode != docNodeFrom && GraphMatcher.compareNodes(insNodeFrom, currentNode)) {
                                return false;
                            }
                            if (neighbour != docNodeTo && GraphMatcher.compareNodes(insNodeTo, currentNode)) {
                                return false;
                            }
                        }
                        if (neighbour == docNodeTo) {
                            DocNode neighbour2;
                            DocEdge edge2;
                            int n2;
                            boolean foundNeighbour2;
                            List<DocNode> neighbours2;
                            ArrayList<DocEdge> edgeList2;
                            if (matchNEdge.getMultipleMatch() == DocEdge.MATCH_N_ANY) {
                                return true;
                            }
                            if (matchNEdge.getMultipleMatch() == DocEdge.MATCH_N_TIL_FIRST) {
                                return true;
                            }
                            DocNode currentNode2 = docNodeTo;
                            boolean loop2 = true;
                            while (loop2) {
                                edgeList2 = new ArrayList<DocEdge>();
                                neighbours2 = GraphMatcher.getNeighboursFrom(currentNode2, documentEdges, edgeList2);
                                foundNeighbour2 = false;
                                n2 = 0;
                                while (n2 < edgeList2.size()) {
                                    edge2 = (DocEdge)edgeList2.get(n2);
                                    if (GraphMatcher.compareEdges(matchNEdge, edge2) && GraphMatcher.compareNodes(insNodeTo, neighbours2.get(n2))) {
                                        neighbour2 = neighbours2.get(n2);
                                        if (GraphMatcher.compareNodes(insNodeTo, neighbour2)) {
                                            return false;
                                        }
                                        n2 = edgeList2.size();
                                        currentNode2 = neighbour2;
                                        foundNeighbour2 = true;
                                    }
                                    ++n2;
                                }
                                if (foundNeighbour2) continue;
                                loop2 = false;
                            }
                            currentNode2 = docNodeFrom;
                            loop2 = true;
                            while (loop2) {
                                edgeList2 = new ArrayList();
                                neighbours2 = GraphMatcher.getNeighboursTo(currentNode2, documentEdges, edgeList2);
                                foundNeighbour2 = false;
                                n2 = 0;
                                while (n2 < edgeList2.size()) {
                                    edge2 = (DocEdge)edgeList2.get(n2);
                                    if (GraphMatcher.compareEdges(matchNEdge, edge2) && GraphMatcher.compareNodes(insNodeFrom, neighbours2.get(n2))) {
                                        neighbour2 = neighbours2.get(n2);
                                        if (GraphMatcher.compareNodes(insNodeFrom, neighbour2)) {
                                            return false;
                                        }
                                        n2 = edgeList2.size();
                                        currentNode2 = neighbour2;
                                        foundNeighbour2 = true;
                                    }
                                    ++n2;
                                }
                                if (foundNeighbour2) continue;
                                loop2 = false;
                            }
                            return true;
                        }
                        n = edgeList.size();
                        currentNode = neighbour;
                        foundNeighbour = true;
                    }
                }
                ++n;
            }
            if (foundNeighbour) continue;
            loop = false;
        }
        return false;
    }

    protected static boolean refineM(boolean[][] M, List<DocNode> instanceNodes, List<DocEdge> instanceEdges, List<DocNode> documentNodes, List<DocEdge> documentEdges) {
        boolean loop = true;
        while (loop) {
            boolean changeMade = false;
            int a = 0;
            while (a < M.length) {
                boolean noOne = true;
                int b = 0;
                while (b < M[a].length) {
                    if (M[a][b]) {
                        noOne = false;
                        boolean forAllX = true;
                        DocNode insNode = instanceNodes.get(a);
                        DocNode docNode = documentNodes.get(b);
                        ArrayList<DocEdge> insNEdges = new ArrayList<DocEdge>();
                        ArrayList<DocEdge> docNEdges = new ArrayList<DocEdge>();
                        List<DocNode> insNeighbours = GraphMatcher.getNeighboursFrom(insNode, instanceEdges, insNEdges);
                        List<DocNode> docNeighbours = GraphMatcher.getNeighboursFrom(docNode, documentEdges, docNEdges);
                        int n = 0;
                        while (n < insNeighbours.size()) {
                            DocNode insN = insNeighbours.get(n);
                            DocEdge insE = (DocEdge)insNEdges.get(n);
                            boolean existsY = false;
                            if (insE.getMultipleMatch() == DocEdge.MATCH_ONE) {
                                int p = 0;
                                while (p < docNeighbours.size()) {
                                    DocNode docN = docNeighbours.get(p);
                                    DocEdge docE = (DocEdge)docNEdges.get(p);
                                    if (GraphMatcher.compareEdges(insE, docE) && GraphMatcher.corresponds(insN, docN, M, instanceNodes, documentNodes)) {
                                        existsY = true;
                                    }
                                    ++p;
                                }
                            } else {
                                List<DocNode> correspondingNodes = GraphMatcher.getCorrespondingNodes(insN, M, instanceNodes, documentNodes);
                                for (DocNode docN : correspondingNodes) {
                                    if (!GraphMatcher.existsMatchNPath(insNode, insN, docNode, docN, insE, documentEdges)) continue;
                                    existsY = true;
                                }
                            }
                            if (!existsY) {
                                forAllX = false;
                            }
                            ++n;
                        }
                        if (!forAllX) {
                            M[a][b] = false;
                            changeMade = true;
                        }
                    }
                    ++b;
                }
                if (noOne) {
                    return false;
                }
                ++a;
            }
            if (changeMade) continue;
            loop = false;
        }
        return true;
    }

    protected static void printBinaryMatrix(boolean[][] M) {
        int a = 0;
        while (a < M.length) {
            int b = 0;
            while (b < M[a].length) {
                if (M[a][b]) {
                    System.out.print(" 1");
                } else {
                    System.out.print(" 0");
                }
                ++b;
            }
            System.out.println();
            ++a;
        }
    }

    protected static void mirrorBinaryMatrix(boolean[][] M) {
        int a = 0;
        while (a < M.length) {
            int b = 0;
            while (b < M[a].length) {
                if (M[a][b]) {
                    M[b][a] = true;
                }
                ++b;
            }
            ++a;
        }
    }

    public static boolean[][] copyBinaryMatrix(boolean[][] M) {
        boolean[][] R = new boolean[M.length][M[0].length];
        int a = 0;
        while (a < M.length) {
            int b = 0;
            while (b < M[a].length) {
                R[a][b] = M[a][b];
                ++b;
            }
            ++a;
        }
        return R;
    }

    protected static boolean compareNodes(DocNode insNode, DocNode docNode) {
        if (!insNode.isTextSegment()) {
            return false;
        }
        if (!docNode.isTextSegment()) {
            return false;
        }
        boolean typographyMatch = true;
        boolean contentMatch = true;
        boolean minLengthMatch = true;
        boolean maxLengthMatch = true;
        if (insNode.isMatchFont() && !insNode.getSegFontName().equals(docNode.getSegFontName())) {
            typographyMatch = false;
        }
        if (insNode.isMatchFontSize() && insNode.getSegFontSize() != docNode.getSegFontSize()) {
            typographyMatch = false;
        }
        if (insNode.isMatchBold() && insNode.isBold() != docNode.isBold()) {
            typographyMatch = false;
        }
        if (insNode.isMatchItalic() && insNode.isItalic() != docNode.isItalic()) {
            typographyMatch = false;
        }
        if (insNode.getMatchContent() == 1 && !docNode.getSegText().trim().equals(insNode.getMatchContentString().trim())) {
            contentMatch = false;
        }
        if (insNode.getMatchContent() == 2 && !docNode.getSegText().contains(insNode.getMatchContentString())) {
            contentMatch = false;
        }
        if (insNode.getMatchContent() == 3 && !docNode.getSegText().trim().matches(insNode.getMatchContentString())) {
            contentMatch = false;
        }
        if (insNode.getMatchMinLength() >= 0 && docNode.getSegText().length() < insNode.getMatchMinLength()) {
            minLengthMatch = false;
        }
        if (insNode.getMatchMaxLength() >= 0 && docNode.getSegText().length() > insNode.getMatchMaxLength()) {
            maxLengthMatch = false;
        }
        return typographyMatch && contentMatch && minLengthMatch && maxLengthMatch;
    }

    protected static boolean compareEdgesAndNodes(DocEdge insEdge, DocEdge docEdge) {
        if (GraphMatcher.compareEdges(insEdge, docEdge)) {
            return GraphMatcher.compareNodes(insEdge.getFrom(), docEdge.getFrom()) && GraphMatcher.compareNodes(insEdge.getTo(), docEdge.getTo());
        }
        return false;
    }

    protected static boolean compareEdges(DocEdge insEdge, DocEdge docEdge) {
        boolean objects = true;
        if (insEdge.getFrom().isTextSegment() != docEdge.getFrom().isTextSegment()) {
            objects = false;
        }
        if (insEdge.getTo().isTextSegment() != docEdge.getTo().isTextSegment()) {
            objects = false;
        }
        boolean relation = false;
        if (insEdge.getRelation().equals(docEdge.getRelation())) {
            relation = true;
        }
        boolean length = true;
        if (insEdge.getMatchLength() == DocEdge.LENGTH_BLOCK && docEdge.getLogicalLength() != DocEdge.LENGTH_BLOCK) {
            length = false;
        }
        if (insEdge.getMatchLength() == DocEdge.LENGTH_COLUMN && docEdge.getLogicalLength() != DocEdge.LENGTH_COLUMN) {
            length = false;
        }
        if (insEdge.getMatchLength() == DocEdge.LENGTH_GREATER && docEdge.getLogicalLength() != DocEdge.LENGTH_GREATER) {
            length = false;
        }
        if (insEdge.getMatchMinLength() != 0.0f && docEdge.getWeight() < insEdge.getMatchMinLength()) {
            length = false;
        }
        if (insEdge.getMatchMaxLength() != 0.0f && docEdge.getWeight() > insEdge.getMatchMaxLength()) {
            length = false;
        }
        boolean alignment = true;
        if (insEdge.isMAlignTopLeft() && docEdge.isAlignTopLeft() != insEdge.isAlignTopLeft()) {
            alignment = false;
        }
        if (insEdge.isMAlignCentre() && docEdge.isAlignCentre() != insEdge.isAlignCentre()) {
            alignment = false;
        }
        if (insEdge.isMAlignBottomRight() && docEdge.isAlignBottomRight() != insEdge.isAlignBottomRight()) {
            alignment = false;
        }
        boolean crossesRulingLine = true;
        if (insEdge.isMatchCrossesRulingLine() && insEdge.isCrossesRulingLine() != docEdge.isCrossesRulingLine()) {
            crossesRulingLine = false;
        }
        boolean readingOrder = true;
        if (insEdge.isMatchReadingOrder() && insEdge.getReadingOrder() != docEdge.getReadingOrder()) {
            readingOrder = false;
        }
        boolean superiorInferior = true;
        if (insEdge.isMatchSuperiorInferior() && insEdge.getSuperiorInferior() != docEdge.getSuperiorInferior()) {
            superiorInferior = false;
        }
        return relation && length && alignment && crossesRulingLine && readingOrder && superiorInferior && objects;
    }

    protected static boolean[][] generateStartMatrix(List<DocNode> instanceNodes, List<DocNode> documentNodes) {
        boolean[][] startMatrix = new boolean[instanceNodes.size()][documentNodes.size()];
        int i1count = -1;
        for (DocNode insN : instanceNodes) {
            ++i1count;
            int i2count = -1;
            for (DocNode docN : documentNodes) {
                ++i2count;
                if (insN.isTextSegment() && docN.isTextSegment()) {
                    if (insN.isTextSegment()) {
                        startMatrix[i1count][i2count] = GraphMatcher.compareNodes(insN, docN);
                        continue;
                    }
                    startMatrix[i1count][i2count] = true;
                    continue;
                }
                startMatrix[i1count][i2count] = false;
            }
        }
        return startMatrix;
    }

    public static boolean checkForConnectedness(DocumentGraph dg) {
        int enabledNodes = 0;
        for (DocNode n : dg.getNodes()) {
            if (n.isRemoveFromInstance()) continue;
            ++enabledNodes;
        }
        if (enabledNodes > 1) {
            for (DocNode n : dg.getNodes()) {
                if (n.isRemoveFromInstance()) continue;
                boolean loneNode = true;
                for (DocEdge ae : dg.edgesFromTo(n)) {
                    if (ae.isRemoveFromInstance() || ae.getFrom() != n && ae.getTo() != n) continue;
                    loneNode = false;
                }
                if (!loneNode) continue;
                return false;
            }
        }
        HashMap<DocNode, List> groupHash = new HashMap<DocNode, List>();
        ArrayList groups = new ArrayList();
        for (DocEdge ae : dg.getEdges()) {
            List nodeFromGroup;
            if (ae.isRemoveFromInstance()) continue;
            DocNode nodeFrom = ae.getFrom();
            DocNode nodeTo = ae.getTo();
            if (groupHash.containsKey(nodeFrom) && groupHash.containsKey(nodeTo)) {
                List nodeToGroup;
                nodeFromGroup = (List)groupHash.get(nodeFrom);
                if (nodeFromGroup == (nodeToGroup = (List)groupHash.get(nodeTo))) continue;
                for (DocNode n : nodeToGroup) {
                    groupHash.put(n, nodeFromGroup);
                    nodeFromGroup.add(n);
                }
                groups.remove(nodeToGroup);
                continue;
            }
            if (groupHash.containsKey(nodeFrom)) {
                nodeFromGroup = (List)groupHash.get(nodeFrom);
                groupHash.put(nodeTo, nodeFromGroup);
                nodeFromGroup.add(nodeTo);
                continue;
            }
            if (groupHash.containsKey(nodeTo)) {
                List nodeToGroup = (List)groupHash.get(nodeTo);
                groupHash.put(nodeFrom, nodeToGroup);
                nodeToGroup.add(nodeFrom);
                continue;
            }
            ArrayList<DocNode> newGroup = new ArrayList<DocNode>();
            newGroup.add(nodeFrom);
            newGroup.add(nodeTo);
            groupHash.put(nodeFrom, newGroup);
            groupHash.put(nodeTo, newGroup);
            groups.add(newGroup);
        }
        return groups.size() <= 1;
    }

    public static List<WrappingInstance> findInstances(DocumentGraph dg, DocumentGraph wrapperGraph, Document resultDocument, List<List<String>> returnFieldNames, List<List<String>> returnExtractedData) {
        List<List<DocNode>> result = GraphMatcher.performExtraction(dg, wrapperGraph, resultDocument, returnFieldNames, returnExtractedData);
        return GraphMatcher.toWrappingInstances(result);
    }

    public static List<WrappingInstance> toWrappingInstances(List<List<DocNode>> result) {
        ArrayList<WrappingInstance> retVal = new ArrayList<WrappingInstance>();
        for (List<DocNode> match : result) {
            retVal.add(new WrappingInstance(match));
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    public static List<List<DocNode>> performExtraction(DocumentGraph dg, DocumentGraph wrapperGraph, Document resultDocument, List<List<String>> returnFieldNames, List<List<String>> returnExtractedData) {
        ArrayList<List<DocNode>> retVal = new ArrayList<List<DocNode>>();
        ArrayList<DocEdge> instanceEdgesTemp = new ArrayList<DocEdge>();
        for (DocEdge e : wrapperGraph.getEdges()) {
            instanceEdgesTemp.add(e);
        }
        HashMap<DocEdge, Object> hm = new HashMap<DocEdge, Object>();
        ArrayList<DocEdge> instanceEdges = new ArrayList<DocEdge>();
        for (DocEdge ae : instanceEdgesTemp) {
            DocEdge cae = (DocEdge)ae.clone();
            instanceEdges.add(cae);
            hm.put(ae, cae);
        }
        ArrayList<DocNode> instanceNodes = new ArrayList<DocNode>();
        for (DocNode n : wrapperGraph.getNodes()) {
            instanceNodes.add(n);
        }
        List<DocNode> documentNodes = dg.getNodes();
        List<DocEdge> documentEdges = dg.getEdges();
        ArrayList<DocEdge> edgesToRemove = new ArrayList<DocEdge>();
        for (DocEdge ae : instanceEdges) {
            if (!ae.isRemoveFromInstance()) continue;
            edgesToRemove.add(ae);
        }
        instanceEdges.removeAll(edgesToRemove);
        ArrayList<DocNode> nodesToRemove = new ArrayList<DocNode>();
        for (DocNode n : instanceNodes) {
            if (!n.isRemoveFromInstance()) continue;
            nodesToRemove.add(n);
        }
        instanceNodes.removeAll(nodesToRemove);
        nodesToRemove = new ArrayList();
        edgesToRemove = new ArrayList();
        for (DocEdge ae : instanceEdges) {
            boolean expand;
            if (ae.getMultipleMatch() == DocEdge.MATCH_ONE || edgesToRemove.contains(ae)) continue;
            DocNode currentNode = ae.getTo();
            DocEdge currentEdge = ae;
            boolean loop = true;
            while (loop) {
                expand = true;
                boolean sidewardsEdges = false;
                DocEdge nextEdge = null;
                for (DocEdge docEdge : instanceEdges) {
                    if (docEdge == currentEdge || docEdge == ae) continue;
                    if (docEdge.getFrom() == currentNode) {
                        if (docEdge.getRelation().equals(currentEdge.getRelation())) {
                            if (nextEdge == null) {
                                nextEdge = docEdge;
                                continue;
                            }
                            expand = false;
                            continue;
                        }
                        expand = false;
                        continue;
                    }
                    if (docEdge.getTo() != currentNode) continue;
                    if (DocEdge.isInverse(docEdge, currentEdge)) {
                        if (nextEdge == null) {
                            nextEdge = docEdge;
                            continue;
                        }
                        expand = false;
                        continue;
                    }
                    expand = false;
                }
                if (expand && nextEdge != null && nextEdge.getMultipleMatch() != DocEdge.MATCH_ONE) {
                    nodesToRemove.add(currentNode);
                    edgesToRemove.add(nextEdge);
                    ae.setTo(nextEdge.getTo());
                    currentEdge = nextEdge;
                    currentNode = nextEdge.getTo();
                    loop = true;
                    continue;
                }
                loop = false;
            }
            currentNode = ae.getFrom();
            currentEdge = ae;
            loop = true;
            while (loop) {
                expand = true;
                DocEdge nextEdge = null;
                for (DocEdge aeCheck2 : instanceEdges) {
                    if (aeCheck2 == currentEdge || aeCheck2 == ae) continue;
                    if (aeCheck2.getTo() == currentNode) {
                        if (aeCheck2.getRelation().equals(currentEdge.getRelation())) {
                            if (nextEdge == null) {
                                nextEdge = aeCheck2;
                                continue;
                            }
                            expand = false;
                            continue;
                        }
                        expand = false;
                        continue;
                    }
                    if (aeCheck2.getFrom() != currentNode) continue;
                    if (DocEdge.isInverse(aeCheck2, currentEdge)) {
                        if (nextEdge == null) {
                            nextEdge = aeCheck2;
                            continue;
                        }
                        expand = false;
                        continue;
                    }
                    expand = false;
                }
                if (expand && nextEdge != null && nextEdge.getMultipleMatch() != DocEdge.MATCH_ONE) {
                    nodesToRemove.add(currentNode);
                    edgesToRemove.add(nextEdge);
                    ae.setFrom(nextEdge.getFrom());
                    currentEdge = nextEdge;
                    currentNode = nextEdge.getFrom();
                    loop = true;
                    continue;
                }
                loop = false;
            }
        }
        instanceEdges.removeAll(edgesToRemove);
        instanceNodes.removeAll(nodesToRemove);
        ArrayList matchNNodes = new ArrayList();
        boolean[][] startMatrix = GraphMatcher.generateStartMatrix(instanceNodes, documentNodes);
        List<boolean[][]> graphMatchResult = GraphMatcher.ullmannAlgorithm(instanceNodes, instanceEdges, documentNodes, documentEdges, startMatrix);
        for (boolean[][] M : graphMatchResult) {
            void var22_31;
            ArrayList<DocNode> match = new ArrayList<DocNode>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<String> extractedData = new ArrayList<String>();
            boolean bl = false;
            while (var22_31 < M.length) {
                int b = 0;
                while (b < M[var22_31].length) {
                    if (M[var22_31][b]) {
                        match.add(documentNodes.get(b));
                        if (documentNodes.get(b).isTextSegment()) {
                            DocNode insTs = (DocNode)instanceNodes.get((int)var22_31);
                            DocNode docTs = documentNodes.get(b);
                            if (insTs.isExtractContent() && !matchNNodes.contains(insTs)) {
                                fieldNames.add(insTs.getSegType());
                                extractedData.add(docTs.getSegText());
                            }
                        }
                    }
                    ++b;
                }
                ++var22_31;
            }
            retVal.add(match);
            if (returnFieldNames != null) {
                returnFieldNames.add(fieldNames);
            }
            if (returnExtractedData == null) continue;
            returnExtractedData.add(extractedData);
        }
        return retVal;
    }

    public static List<boolean[][]> ullmannAlgorithm(List<DocNode> instanceNodes, List<DocEdge> instanceEdges, List<DocNode> documentNodes, List<DocEdge> documentEdges, boolean[][] M) {
        int noInsNodes = instanceNodes.size();
        int noDocNodes = documentNodes.size();
        ArrayList<boolean[][]> retVal = new ArrayList<boolean[][]>();
        boolean[][][] Md = new boolean[noDocNodes][noInsNodes][noDocNodes];
        int a = 0;
        while (a < noDocNodes) {
            int b = 0;
            while (b < noInsNodes) {
                int c = 0;
                while (c < noDocNodes) {
                    Md[a][b][c] = false;
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        int d = 0;
        int k = -1;
        boolean[] F = new boolean[noDocNodes];
        int[] H = new int[noInsNodes];
        H[0] = -1;
        int possibleIsomorphisms = 0;
        int isomorphisms = 0;
        int i = 0;
        while (i < F.length) {
            F[i] = false;
            ++i;
        }
        boolean loop = true;
        int nextStep = 2;
        int iteration = -1;
        if (!GraphMatcher.refineM(M, instanceNodes, instanceEdges, documentNodes, documentEdges)) {
            System.out.println("terminating algorithm at first step!");
            loop = false;
        }
        while (loop) {
            if (++iteration % 10000 == 0) {
                System.out.println("Iteration: " + iteration);
            }
            switch (nextStep) {
                case 2: {
                    int b;
                    int a2;
                    boolean valueFound = false;
                    int j = 0;
                    while (j < noDocNodes) {
                        if (M[d][j] && !F[j]) {
                            valueFound = true;
                        }
                        ++j;
                    }
                    if (valueFound) {
                        a2 = 0;
                        while (a2 < noInsNodes) {
                            b = 0;
                            while (b < noDocNodes) {
                                Md[d][a2][b] = M[a2][b];
                                ++b;
                            }
                            ++a2;
                        }
                        k = d == 0 ? H[0] : -1;
                        nextStep = 3;
                        break;
                    }
                    nextStep = 7;
                    break;
                }
                case 3: {
                    if (!M[d][++k] || F[k]) {
                        nextStep = 3;
                        break;
                    }
                    int j = 0;
                    while (j < noDocNodes) {
                        if (j != k) {
                            M[d][j] = false;
                        }
                        ++j;
                    }
                    nextStep = 4;
                    if (GraphMatcher.refineM(M, instanceNodes, instanceEdges, documentNodes, documentEdges)) break;
                    nextStep = 5;
                    break;
                }
                case 4: {
                    if (d < noInsNodes - 1) {
                        nextStep = 6;
                        break;
                    }
                    ++possibleIsomorphisms;
                    ++isomorphisms;
                    retVal.add(GraphMatcher.copyBinaryMatrix(M));
                    nextStep = 5;
                    break;
                }
                case 5: {
                    int b;
                    int a2 = 0;
                    while (a2 < noInsNodes) {
                        b = 0;
                        while (b < noDocNodes) {
                            M[a2][b] = Md[d][a2][b];
                            ++b;
                        }
                        ++a2;
                    }
                    boolean valueFound = false;
                    int j = k + 1;
                    while (j < noDocNodes) {
                        if (j > k && M[d][j] && !F[j]) {
                            valueFound = true;
                        }
                        ++j;
                    }
                    if (!valueFound) {
                        nextStep = 7;
                        break;
                    }
                    nextStep = 3;
                    break;
                }
                case 6: {
                    H[d] = k;
                    F[k] = true;
                    ++d;
                    nextStep = 2;
                    break;
                }
                case 7: {
                    int b;
                    if (d == 0) {
                        loop = false;
                        break;
                    }
                    --d;
                    int a2 = 0;
                    while (a2 < noInsNodes) {
                        b = 0;
                        while (b < noDocNodes) {
                            M[a2][b] = Md[d][a2][b];
                            ++b;
                        }
                        ++a2;
                    }
                    k = H[d];
                    F[k] = false;
                    nextStep = 5;
                }
            }
        }
        System.out.println("Number of iterations: " + iteration);
        return retVal;
    }

    public static List<WrappingInstance> wrap(Document resultDocument, Element resultElement, DocumentGraph pageDg, Element wrapperElement) {
        boolean output = true;
        if (wrapperElement.getAttributes().getNamedItem("output") != null) {
            output = Boolean.parseBoolean(wrapperElement.getAttributes().getNamedItem("output").getNodeValue());
        }
        boolean areaBased = true;
        if (wrapperElement.getAttributes().getNamedItem("area-based") != null) {
            areaBased = Boolean.parseBoolean(wrapperElement.getAttributes().getNamedItem("area-based").getNodeValue());
        }
        boolean wholePage = false;
        if (wrapperElement.getAttributes().getNamedItem("whole-page") != null) {
            wholePage = Boolean.parseBoolean(wrapperElement.getAttributes().getNamedItem("area-based").getNodeValue());
        }
        NodeList listOfItems = wrapperElement.getChildNodes();
        DocumentGraph wrapperDg = new DocumentGraph(listOfItems);
        ArrayList<GenericSegment> pageItems = new ArrayList<GenericSegment>();
        for (DocNode dn : wrapperDg.getNodes()) {
            pageItems.add(dn.toGenericSegment());
        }
        ArrayList<List<String>> returnFieldNames = new ArrayList<List<String>>();
        ArrayList<List<String>> returnExtractedData = new ArrayList<List<String>>();
        List<List<DocNode>> matchList = GraphMatcher.performExtraction(pageDg, wrapperDg, resultDocument, returnFieldNames, returnExtractedData);
        List<WrappingInstance> result = GraphMatcher.toWrappingInstances(matchList);
        if (wholePage) {
            ArrayList<List<WrappingInstance>> subResults = new ArrayList<List<WrappingInstance>>();
            int s = 0;
            while (s < listOfItems.getLength()) {
                Node itemNode = listOfItems.item(s);
                if (itemNode.getNodeType() == 1 && itemNode.getNodeName().equals("pdf-wrapper")) {
                    ArrayList<List<String>> dummyRFN = new ArrayList<List<String>>();
                    ArrayList<List<String>> dummyRED = new ArrayList<List<String>>();
                    NodeList listOfSubItems = itemNode.getChildNodes();
                    DocumentGraph subWrapperDg = new DocumentGraph(listOfSubItems);
                    List<WrappingInstance> subResult = GraphMatcher.findInstances(pageDg, subWrapperDg, null, dummyRFN, dummyRED);
                    int i = 0;
                    while (i < subResult.size()) {
                        WrappingInstance subInstance = subResult.get(i);
                        if (areaBased) {
                            List<GenericSegment> items = ListUtils.findElementsIntersectingBBox(pageItems, subInstance);
                            WrappingInstance wi = new WrappingInstance();
                            wi.setItems(items);
                            wi.findBoundingBox();
                            subResult.set(i, wi);
                        }
                        ++i;
                    }
                    subResults.add(subResult);
                }
                ++s;
            }
            int cellCount = 0;
            int n = 0;
            while (n < result.size()) {
                WrappingInstance thisResult = result.get(n);
                if (areaBased) {
                    List<GenericSegment> items = ListUtils.findElementsIntersectingBBox(pageItems, thisResult);
                    thisResult = new WrappingInstance();
                    thisResult.setItems(items);
                    thisResult.findBoundingBox();
                }
                System.out.println("******************");
                System.out.println("Top-level result: ");
                Collections.sort(thisResult.getItems(), new XComparator());
                Element subResultElement = resultElement;
                if (output) {
                    boolean intersects = false;
                    int p = 0;
                    while (p < subResults.size()) {
                        ArrayList<GenericSegment> intersections = new ArrayList<GenericSegment>();
                        List subResult = (List)subResults.get(p);
                        int r = 0;
                        while (r < subResult.size()) {
                            WrappingInstance subInstance = (WrappingInstance)subResult.get(r);
                            List<GenericSegment> intersection = ListUtils.intersection(thisResult.getItems(), subInstance.getItems());
                            intersections.addAll(intersection);
                            if (intersection.size() > 0) {
                                intersects = true;
                            }
                            ++r;
                        }
                        ++p;
                    }
                }
                ++n;
            }
            System.out.println("cells on page: " + cellCount);
        } else {
            int n = 0;
            while (n < matchList.size()) {
                Element subResultElement = resultElement;
                if (output) {
                    subResultElement = resultDocument.createElement("wrapper-result");
                    resultElement.appendChild(subResultElement);
                    List resultFieldNames = (List)returnFieldNames.get(n);
                    List resultExtractedData = (List)returnExtractedData.get(n);
                    int p = 0;
                    while (p < resultExtractedData.size()) {
                        Element newFieldElement = resultDocument.createElement((String)resultFieldNames.get(p));
                        subResultElement.appendChild(newFieldElement);
                        newFieldElement.appendChild(resultDocument.createTextNode((String)resultExtractedData.get(p)));
                        ++p;
                    }
                }
                WrappingInstance instance = result.get(n);
                List<DocNode> match = matchList.get(n);
                if (areaBased) {
                    match.clear();
                    for (DocNode dn : pageDg.getNodes()) {
                        GenericSegment testSeg = dn.toGenericSegment();
                        if (!SegmentUtils.intersects(testSeg, instance)) continue;
                        match.add(dn);
                    }
                }
                DocumentGraph subPageDg = pageDg.subGraph(match);
                int s = 0;
                while (s < listOfItems.getLength()) {
                    Node itemNode = listOfItems.item(s);
                    if (itemNode.getNodeType() == 1 && itemNode.getNodeName().equals("pdf-wrapper") && !wholePage) {
                        GraphMatcher.wrap(resultDocument, subResultElement, subPageDg, (Element)itemNode);
                    }
                    ++s;
                }
                ++n;
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        boolean toConsole = false;
        int processType = -1;
        int processSpacesCommandLine = 0;
        int rulingLinesCommandLine = 0;
        boolean currentArgumentIndex = false;
        String password = "";
        String encoding = "UTF-8";
        PDFObjectExtractor extractor = new PDFObjectExtractor();
        String inDocFile = null;
        String inWrapperFile = null;
        String outFile = null;
        boolean processSpaces = false;
        boolean rulingLines = true;
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-test")) {
                ++i;
                System.err.println("This function is not available in this version.");
                System.exit(0);
            }
            if (args[i].equals("-password")) {
                if (++i >= args.length) {
                    GraphMatcher.usage();
                }
                password = args[i];
            } else if (args[i].equals("-encoding")) {
                if (++i >= args.length) {
                    GraphMatcher.usage();
                }
                encoding = args[i];
            } else if (args[i].equals("-startPage")) {
                if (++i >= args.length) {
                    GraphMatcher.usage();
                }
                startPage = Integer.parseInt(args[i]);
            } else if (args[i].equals("-endPage")) {
                if (++i >= args.length) {
                    GraphMatcher.usage();
                }
                endPage = Integer.parseInt(args[i]);
            } else if (args[i].equals("-console")) {
                toConsole = true;
            } else if (args[i].equals("-rulinglines")) {
                rulingLinesCommandLine = 1;
            } else if (args[i].equals("-norulinglines")) {
                rulingLinesCommandLine = -1;
            } else if (args[i].equals("-blocks")) {
                processType = 5;
            } else if (args[i].equals("-mergedlines")) {
                processType = 16;
            } else if (args[i].equals("-lines")) {
                processType = 4;
            } else if (args[i].equals("-spaces")) {
                processSpacesCommandLine = 1;
            } else if (args[i].equals("-nospaces")) {
                processSpacesCommandLine = -1;
            } else if (inDocFile == null) {
                inDocFile = args[i];
            } else if (inWrapperFile == null) {
                inWrapperFile = args[i];
            } else {
                outFile = args[i];
            }
            ++i;
        }
        if (inDocFile == null && inWrapperFile == null) {
            GraphMatcher.usage();
        }
        if (outFile == null && inDocFile.length() > 4) {
            outFile = String.valueOf(inDocFile.substring(0, inDocFile.length() - 4)) + ".txt";
        }
        long docStart = System.currentTimeMillis();
        File inputDocFile = new File(inDocFile);
        byte[] inputDoc = ProcessFile.getBytesFromFile(inputDocFile);
        File inputWrapperFile = new File(inWrapperFile);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document wrapperDocument = docBuilder.parse(inputWrapperFile);
        Document resultDocument = null;
        wrapperDocument.getDocumentElement().normalize();
        Element rootWrapper = (Element)wrapperDocument.getElementsByTagName("pdf-wrapper").item(0);
        String granularity = rootWrapper.getAttributes().getNamedItem("granularity").getNodeValue();
        if (rootWrapper.getAttributes().getNamedItem("process-spaces") != null) {
            processSpaces = Boolean.parseBoolean(rootWrapper.getAttributes().getNamedItem("process-spaces").getNodeValue());
        }
        if (rootWrapper.getAttributes().getNamedItem("process-ruling-lines") != null) {
            rulingLines = Boolean.parseBoolean(rootWrapper.getAttributes().getNamedItem("process-ruling-lines").getNodeValue());
        }
        if (processType == -1) {
            if (granularity.equals("raw-line")) {
                processType = 4;
            } else if (granularity.equals("line")) {
                processType = 16;
            } else if (granularity.equals("block")) {
                processType = 5;
            }
        }
        if (processSpacesCommandLine == 1) {
            processSpaces = true;
        } else if (processSpacesCommandLine == -1) {
            processSpaces = false;
        }
        if (rulingLinesCommandLine == 1) {
            rulingLines = true;
        } else if (rulingLinesCommandLine == -1) {
            rulingLines = false;
        }
        ArrayList<AdjacencyGraph<GenericSegment>> theAdjGraphs = new ArrayList<AdjacencyGraph<GenericSegment>>();
        PageProcessor pp = new PageProcessor();
        pp.setProcessType(processType);
        pp.setRulingLines(rulingLines);
        pp.setProcessSpaces(processSpaces);
        List<Page> theResult = ProcessFile.processPDF(inputDoc, pp, startPage, endPage, encoding, password, theAdjGraphs, false);
        try {
            DocumentBuilderFactory myFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder myDocBuilder = myFactory.newDocumentBuilder();
            DOMImplementation myDOMImpl = myDocBuilder.getDOMImplementation();
            resultDocument = myDOMImpl.createDocument("at.ac.tuwien.dbai.pdfwrap", "pdf-result", null);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.out.println("error");
            return;
        }
        Element resultElement = resultDocument.getDocumentElement();
        int p = 0;
        while (p < theResult.size()) {
            System.out.println("Page: " + (p + 1));
            long pageStart = System.currentTimeMillis();
            Page resultPage = theResult.get(p);
            DocumentGraph pageDg = new DocumentGraph((AdjacencyGraph)theAdjGraphs.get(p));
            Element pageResultElement = resultDocument.createElement("page");
            pageResultElement.setAttribute("page-number", Integer.toString(p + 1));
            resultElement.appendChild(pageResultElement);
            List<WrappingInstance> result = GraphMatcher.wrap(resultDocument, pageResultElement, pageDg, wrapperDocument.getDocumentElement());
            System.out.println("processing time for page: " + (System.currentTimeMillis() - pageStart));
            ++p;
        }
        System.out.println("processing time for document: " + (System.currentTimeMillis() - docStart));
        OutputStreamWriter output = null;
        output = toConsole ? new OutputStreamWriter(System.out) : (encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding) : new OutputStreamWriter(new FileOutputStream(outFile)));
        ProcessFile.serializeXML(resultDocument, output);
        if (output != null) {
            ((Writer)output).close();
        }
    }

    private static void usage() {
        System.err.println("Usage: graphwrap [OPTIONS] <PDF file> <Wrapper file> [Output file]\n  -password  <password>        Password to decrypt document\n  -encoding  <output encoding> (ISO-8859-1,UTF-16BE,UTF-16LE,...)\n  -spaces | -spaces            Override processing settings in wrapper\n  -blocks | -lines | mergedlines\n  -rulinglines | -norulinglines\n  -console                     Send text to console instead of file\n  -startPage <number>          The first page to start extraction (1 based)\n  -endPage <number>            The last page to extract (inclusive)\n  <PDF file>                   The PDF document to use\n  <Wrapper file>               The XML wrapper file to use\n  [Output File]                The output XML file name\n");
        System.exit(1);
    }
}

