/*++
/* NAME
/*	qmgr_bounce
/* SUMMARY
/*	deal with mail that will not be delivered
/* SYNOPSIS
/*	#include "qmgr.h"
/*
/*	QMGR_QUEUE *qmgr_bounce_recipient(message, recipient, dsn)
/*	QMGR_MESSAGE *message;
/*	RECIPIENT *recipient;
/*	DSN	*dsn;
/* DESCRIPTION
/*	qmgr_bounce_recipient() produces a bounce log record.
/*	Once the bounce record is written successfully, the recipient
/*	is marked as done. When the bounce record cannot be written,
/*	the message structure is updated to reflect that the mail is
/*	deferred.
/*
/*	Arguments:
/* .IP message
/*	Open queue file with the message being bounced.
/* .IP recipient
/*	The recipient that will not be delivered.
/* .IP dsn
/*	Delivery status information. See dsn(3).
/* DIAGNOSTICS
/*	Panic: consistency check failure. Fatal: out of memory.
/* LICENSE
/* .ad
/* .fi
/*	The Secure Mailer license must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*
/*	Scheduler enhancements:
/*	Patrik Rak
/*	Modra 6
/*	155 00, Prague, Czech Republic
/*--*/

/* System library. */

#include <sys_defs.h>

/* Utility library. */

/* Global library. */

#include <bounce.h>
#include <deliver_completed.h>

/* Application-specific. */

#include "qmgr.h"

/* qmgr_bounce_recipient - bounce one message recipient */

void    qmgr_bounce_recipient(QMGR_MESSAGE *message, RECIPIENT *recipient,
			              DSN *dsn)
{
    int     status;

    status = bounce_append(message->tflags, message->queue_id,
			   message->arrival_time, recipient,
			   "none", dsn);

    if (status == 0)
	deliver_completed(message->fp, recipient->offset);
    else
	message->flags |= status;
}
