/*++
/* NAME
/*	cyrus_security 3
/* SUMMARY
/*	Cyrus SASL status code to string
/* SYNOPSIS
/*	#include <cyrus_common.h>
/*
/*	const char *cyrus_security_parse_opts(paramname, properties)
/*	const char *paramname;
/*	const char *properties;
/* DESCRIPTION
/*	cyrus_security_parse_opts() converts a list of security properties to
/*	a bit mask.
/*
/*	Arguments:
/* .IP paramname
/*	Configuration parameter name, used for diagnostics.
/* .IP properties
/*	Configuration parameter value. Specify a list of zero or
/*	more of the following:
/* .RS
/* .IP noplaintext
/*	Disallow authentication methods that use plaintext passwords.
/* .IP noactive
/*	Disallow authentication methods that are vulnerable to
/*	non-dictionary active attacks.
/* .IP nodictionary
/*	Disallow authentication methods that are vulnerable to
/*	passive dictionary attack.
/* .IP noanonymous
/*	Disallow anonymous logins.
/* .RE
/* DIAGNOSTICS:
/*	Fatal: bad input.
/* LICENSE
/* .ad
/* .fi
/*	The Secure Mailer license must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*--*/

/* System library. */

#include <sys_defs.h>

/* Utility library. */

#include <name_mask.h>

/* Application-specific. */

#include <cyrus_common.h>

#ifdef USE_SASL_AUTH
#include <sasl.h>

 /*
  * SASL Security options.
  */
static NAME_MASK cyrus_sec_mask[] = {
    "noplaintext", SASL_SEC_NOPLAINTEXT,
    "noactive", SASL_SEC_NOACTIVE,
    "nodictionary", SASL_SEC_NODICTIONARY,
    "noanonymous", SASL_SEC_NOANONYMOUS,
#if SASL_VERSION_MAJOR >= 2
    "mutual_auth", SASL_SEC_MUTUAL_AUTH,
#endif
    0,
};

/* cyrus_security - parse security options */

int     cyrus_security_parse_opts(const char *sasl_opts_name,
				          const char *sasl_opts_val)
{
    return (name_mask(sasl_opts_name, cyrus_sec_mask, sasl_opts_val));
}

#endif
