/*++
/* NAME
/*	cyrus_strerror 3
/* SUMMARY
/*	Cyrus SASL status code to string
/* SYNOPSIS
/*	#include <cyrus_common.h>
/*
/*	const char *cyrus_strerror(code)
/*	int	code;
/* DESCRIPTION
/*	cyrus_strerror() maps a Cyrus SASL status to printable string.
/* DIAGNOSTICS:
/*	Fatal: out of memory.
/* LICENSE
/* .ad
/* .fi
/*	The Secure Mailer license must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*--*/

/* System library. */

#include <sys_defs.h>

/* Utility library. */

#include <vstring.h>
#include <msg.h>

#ifdef USE_SASL_AUTH

/* SASL library. */

#include <sasl.h>

/* XSASL library. */

#include <cyrus_common.h>

 /*
  * Mapping from status code to printable string.
  */
typedef struct {
    int     status;
    const char *text;
} CYRUS_ERROR_INFO;

static CYRUS_ERROR_INFO cyrus_error_table[] = {
#include "cyrus_error_table.h"
    0,
};

/* cyrus_strerror - map status code to printable string */

const char *cyrus_strerror(unsigned status)
{
    CYRUS_ERROR_INFO *cp;
    static VSTRING *other;
    unsigned i;

    for (cp = cyrus_error_table; cp->text != 0; cp++)
	if (cp->status == status)
	    return (cp->text);

    if (other == 0)
	other = vstring_alloc(10);
    vstring_sprintf(other, "Unknown SASL status 0x%x", status);
    return (vstring_str(other));
}

#endif
