#ifndef _XSASL_SERVER_H_INCLUDED_
#define _XSASL_SERVER_H_INCLUDED_

/*++
/* NAME
/*	xsasl_server 3h
/* SUMMARY
/*	Postfix SASL server plug-in interface
/* SYNOPSIS
/*	#include <xsasl_server.h>
/* DESCRIPTION
/* .nf

 /*
  * Utility library.
  */
#include <vstring.h>

 /*
  * Generic server object. Specific instances extend this with their own
  * private data.
  */
typedef struct XSASL_SERVER {
    void    (*free) (struct XSASL_SERVER *);
    int     (*first) (struct XSASL_SERVER *, const char *, const char *, VSTRING *);
    int     (*next) (struct XSASL_SERVER *, const char *, VSTRING *);
    int     (*set_security) (struct XSASL_SERVER *, const char *, const char *);
    const char *(*get_mechanism_list) (struct XSASL_SERVER *);
    const char *(*get_username) (struct XSASL_SERVER *);
} XSASL_SERVER;

#define xsasl_server_free(server) (server)->free(server)
#define xsasl_server_first(server, method, init_resp, reply) \
	(server)->first((server), (method), (init_resp), (reply))
#define xsasl_server_next(server, request, reply) \
	(server)->next((server), (request), (reply))
#define xsasl_server_set_security(server, paramname, security) \
	(server)->set_security((server), (paramname), (security))
#define xsasl_server_get_mechanism_list(server) \
	(server)->get_mechanism_list((server))
#define xsasl_server_get_username(server) \
	(server)->get_username((server))

#define XSASL_SERVER_AUTH_MORE	1
#define XSASL_SERVER_AUTH_DONE	2
#define XSASL_SERVER_AUTH_FORM	3
#define XSASL_SERVER_AUTH_FAIL	4

 /*
  * Generic server implementation. Specific instances extend this with their
  * own private data.
  */
typedef struct XSASL_SERVER_IMPL {
    XSASL_SERVER *(*create) (const char *, const char *);
} XSASL_SERVER_IMPL;

extern XSASL_SERVER_IMPL *xsasl_server_init(const char *, const char *);

#define xsasl_server_create(impl, service, realm) \
	(impl)->create((service), (realm))

/* LICENSE
/* .ad
/* .fi
/*	The Secure Mailer license must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*--*/

#endif
