/*
**  Copyright (c) 2006 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: util.h,v 1.12 2006/06/09 23:00:17 msk Exp $
*/

#ifndef _UTIL_H_
#define _UTIL_H_

/* system includes */
#include <sys/types.h>

/* libsm includes */
#include <sm/gen.h>

/* nesting-filter includes */
#include "nesting-filter.h"

#ifndef lint
static char util_h_id[] = "@(#)$Id: util.h,v 1.12 2006/06/09 23:00:17 msk Exp $";
#endif /* !lint */

/* TYPES */
struct string_handle
{
	int			str_len;
	int			str_alloc;
	unsigned char *		str_data;
};
typedef struct string_handle * STRING;

struct vector_handle
{
	int			vector_len;
	int			vector_alloc;
	void **			vector_data;
};
typedef struct vector_handle * VECTOR;

struct tokens_handle
{
	STRING 			tok_data;
	VECTOR			tok_strings;
	VECTOR			tok_elems;
};
typedef struct tokens_handle * TOKENS;

/* PROTOTYPES */
extern void string_blank __P((STRING));
extern int string_cat __P((STRING, unsigned char *));
extern int string_cat1 __P((STRING, unsigned int));
extern void string_chop __P((STRING, int));
extern unsigned char *string_data __P((STRING));
extern void string_free __P((STRING));
extern int string_length __P((STRING));
extern STRING string_new __P((int));

extern void tokens_free __P((TOKENS));
extern STRING tokens_getdata __P((TOKENS));
extern unsigned char **tokens_gettokens __P((TOKENS));
extern TOKENS tokens_new __P((void));
extern int tokens_tokenize __P((TOKENS, unsigned char *, unsigned char *));

extern int vector_append __P((VECTOR, void *));
extern void vector_clear __P((VECTOR));
extern void *vector_data __P((VECTOR));
extern void vector_free __P((VECTOR));
extern void *vector_index __P((VECTOR, int));
extern int vector_length __P((VECTOR));
extern VECTOR vector_new __P((unsigned int));
extern void *vector_remove __P((VECTOR, int));

extern bool nf_blankline __P((unsigned char *));
extern bool nf_isheader __P((unsigned char *));
extern bool nf_ishspace __P((unsigned int));
extern void nf_setmaxfd __P((void));

#endif /* _UTIL_H_ */
