/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-cstr.c,v 1.12 2005/04/27 17:22:08 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/test.h"
#include "sm/cstr.h"

#include <stdio.h>

static void
test_harness(void)
{
	sm_cstr_P s, s2, s3, s4;
	size_t l, l2;
	char *src1 = "magic buf";
	char *src2 = "mAgIc strbUf";

	l = strlen(src1);
	s = sm_cstr_scpyn((const uchar *) src1, l);
	SM_TEST(s != NULL);
	SM_TEST(sm_cstr_getlen(s) == l);
	SM_TEST(sm_memeq(sm_cstr_data(s), src1, l));

	s2 = sm_cstr_scpyn((const uchar *) src1, l);
	SM_TEST(s2 != NULL);
	s3 = SM_CSTR_DUP(s2);
	SM_TEST(s3 != NULL);
	s4 = sm_cstr_scpyn((const uchar *) src2, strlen(src2));
	SM_TEST(s4 != NULL);

	SM_TEST(SM_CSTR_EQ(s, s2));
	SM_TEST(SM_CSTR_EQ(s, s3));
	SM_TEST(SM_CSTR_CASEQ(s, s2));
	SM_TEST(SM_CSTR_CASEQ(s, s3));
	SM_TEST(!SM_CSTR_EQ(s, s4));
	SM_TEST(!SM_CSTR_EQ(s2, s4));
	SM_TEST(!SM_CSTR_EQ(s3, s4));

	SM_TEST(s2->sm_cstr_refcnt == 2);
	SM_CSTR_FREE(s3);
	SM_TEST(s2->sm_cstr_refcnt == 1);

	SM_TEST(SM_CSTR_EQ(s, s2));
	SM_CSTR_FREE(s4);
	SM_CSTR_FREE(s2);
	SM_CSTR_FREE(s);

	l = strlen(src1);
	s = sm_cstr_scpyvn0((const uchar *) src1, l, NULL);
	SM_TEST(s != NULL);
	SM_TEST(sm_cstr_getlen(s) == l);
	SM_TEST(sm_memeq(sm_cstr_data(s), src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s), src1, l + 1));
	SM_CSTR_FREE(s);

	l = strlen(src1);
	s = sm_cstr_scpyvn0(
			(const uchar *) src1, l,
			(const uchar *) src1, l,
			NULL);
	SM_TEST(s != NULL);
	SM_TEST(sm_cstr_getlen(s) == l * 2);
	SM_TEST(sm_memeq(sm_cstr_data(s), src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l, src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l, src1, l + 1));
	SM_CSTR_FREE(s);

	l = strlen(src1);
	s = sm_cstr_scpyvn0(
			(const uchar *) src1, l,
			(const uchar *) src1, l,
			(const uchar *) src1, l,
			NULL);
	SM_TEST(s != NULL);
	SM_TEST(sm_cstr_getlen(s) == l * 3);
	SM_TEST(sm_memeq(sm_cstr_data(s), src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l, src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l * 2, src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l * 2, src1, l + 1));
	SM_CSTR_FREE(s);

	l = strlen(src1);
	l2 = strlen(src2);
	s = sm_cstr_scpyvn0(
			(const uchar *) src1, l,
			(const uchar *) src2, l2,
			NULL);
	SM_TEST(s != NULL);
	SM_TEST(sm_cstr_getlen(s) == l + l2);
	SM_TEST(sm_memeq(sm_cstr_data(s), src1, l));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l, src2, l2));
	SM_TEST(sm_memeq(sm_cstr_data(s) + l, src2, l2 + 1));
	SM_CSTR_FREE(s);

}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test cstr");
	test_harness();
	return sm_test_end();
}
