#!/bin/sh
# $Id: t-bounce-3.sh,v 1.17 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-3.ok"
OUT="t-bounce-3.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# Note: the test programs which rely on failures from SMAR work only if
# SMAR has been compiled with -DSMAR_TEST!
SMAR_TEST=false
../smar/smar -D | ${GREP} "SMAR_TEST" >/dev/null && SMAR_TEST=true

if ${SMAR_TEST}
then
  :
else
  echo "$0 SKIPPED"
  exit 0
fi

# ----------------------------------------
# temporary failure from SMAR; check content
TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<user@t.z>
error from address resolver
temporary error
maximum time in queue exceeded


Your original mail follows:
EOF

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R"user@t.z" -i 4 -E 0 -X 0 -A 1 -s 90 -Q '-T 30'
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi

# ----------------------------------------
# two temporary failures from sink; check content
TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<user@x.y>
Remote-MTA: 127.0.0.1
Reason:
454 4.7.4 temp 4
during MAIL
maximum time in queue exceeded


Your original mail follows:
EOF

if ${SHELL} ${SD}/smtp1.sh -Y '-5 RM' -3 lmtpsock -Ssender@local.dom -R"user@x.y" -i 4 -E 1 -X 0 -A 1 -s 90 -Q '-T 30'
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
