#!/bin/sh
# $Id: t-smtp-421-0.sh,v 1.8 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling for 421 from sink
# Note: some these tests require that the order of recipients is preserved,
# because one recipient fails with 421 and hence the connection is terminated.
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
EDBROK="../qmgr/t-smtp-421-edbr.ok"
EDBROK2="../qmgr/t-smtp-421-edbr2.ok"
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

# run some test programs

TEST=1
# ----------------------------------------
# temporary failure from SMTP sink, single recipient
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<s1@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=421
	aqt_rcpts_ar=0
got recipient
	rcpt=<421@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=421
EOF

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -O ${EDBROK} -S"s1@b.c" -R"421@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


TEST=2
# ----------------------------------------
# temporary failure from SMTP sink, two recipients, first fails with 421
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<s2@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=421
	aqt_rcpts_ar=0
got recipient
	rcpt=<421@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=421
got recipient
	rcpt=<ok2@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=499
EOF
${CAT} > ${EDBROK2} <<EOF
got transaction
	mail=<s2@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=421
	aqt_rcpts_ar=0
got recipient
	rcpt=<421@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=421
got recipient
	rcpt=<ok2@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=421
EOF

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -E '2|1' -O ${EDBROK} -K ${EDBROK2} -S"s2@b.c" -R"421@y.z -Rok2@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


TEST=3
# ----------------------------------------
# temporary failure from SMTP sink, two recipients, second fails with 421
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<s3@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=421
	aqt_rcpts_ar=0
got recipient
	rcpt=<ok3@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=421
got recipient
	rcpt=<421@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=421
EOF
${CAT} > ${EDBROK2} <<EOF
got transaction
	mail=<s3@b.c>
	rcpts_tot=2
	rcpts_left=2
	rcpts_temp=2
	rcpts_perm=0
	state=421
	aqt_rcpts_ar=0
got recipient
	rcpt=<ok3@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=499
got recipient
	rcpt=<421@y.z>
	aqr_rcpt_idx=1
	aqr_da_idx=0
	aqr_status=421
EOF

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -E '1|2' -O ${EDBROK} -K ${EDBROK2} -S"s3@b.c" -R"ok3@y.z -R421@y.z"
then
    :
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${EDBROK} ${EDBROK2}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
