/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: pfxsm.h,v 1.5 2002/06/03 23:42:11 ca Exp $
 */

#ifndef PFX_SM_PFXSM_H
#define PFX_SM_PFXSM_H

/* macros to emulate postfix functions by sendmail routines */

#include "sm/generic.h"

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/magic.h"
#include "sm/types.h"
#include "sm/rpool.h"
#include "sm/memops.h"
#include "sm/io.h"
#include "sm/str.h"

/* vstring */
#define VSTRING	sm_str_T
#define vstring_free(str)	sm_str_free(str)
#define vstring_alloc(rpool, size) sm_str_new(rpool, size, TOK822_MAXLEN)
#define VSTRING_ADDCH(str, c)	sm_str_put(str, c)
#define VSTRING_TERMINATE(str)	sm_str_term(str)
#define VSTRING_RESET(str)	sm_str_clr(str)
#define vstring_strcat(str, cp)	sm_str_scat(str, cp)
#define vstring_str(str)	sm_str_getdata(str)

#define msg_panic	sm_abort

#endif /* PFX_SM_PFXSM_H */
