/*
 * Copyright (c) 2001-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: cdefs.h,v 1.11 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_CDEFS_H
#define SM_CDEFS_H 1

#include "sm/generic.h"

#if HAVE_SYS_CDEFS_H
# include <sys/cdefs.h>
#endif

/*
**  Define the standard C language portability macros
**  for platforms that lack <sys/cdefs.h>.
*/

#if !HAVE_SYS_CDEFS_H
# if defined(__STDC__) || defined(__cplusplus)
#  define __CONCAT(x,y)	x ## y
#  define __STRING(x)	#x
# else /* defined(__STDC__) || defined(__cplusplus) */
#  define __CONCAT(x,y)	x/**/y
#  define __STRING(x)	"x"
#  define const
#  define signed
#  define volatile
# endif /* defined(__STDC__) || defined(__cplusplus) */
#endif /* !HAVE_SYS_CDEFS_H */

#ifndef __BEGIN_DECLS
# if defined(__cplusplus)
#  define __BEGIN_DECLS	extern "C" {
#  define __END_DECLS	};
# else /* defined(__cplusplus) */
#  define __BEGIN_DECLS
#  define __END_DECLS
# endif /* defined(__cplusplus) */
#endif /* ! __BEGIN_DECLS */

/*
**  Define SM_DEAD, a macro used to declare functions that do not return
**  to their caller.
*/

# ifndef SM_DEAD
#  if __GNUC__ >= 2
#   if __GNUC__ == 2 && __GNUC_MINOR__ < 5
#    define SM_DEAD(proto) volatile proto
#   else
#    define SM_DEAD(proto) proto __attribute__((__noreturn__))
#   endif
#  else /* __GNUC__ >= 2 */
#   define SM_DEAD(proto) proto
#  endif /* __GNUC__ >= 2 */
# endif /* SM_DEAD */

/*
**  Define SM_UNUSED, a macro used to declare variables that may be unused.
*/

# ifndef SM_UNUSED
#  if __GNUC__ >= 2
#   if __GNUC__ == 2 && __GNUC_MINOR__ < 7
#    define SM_UNUSED(decl) decl
#   else
#    define SM_UNUSED(decl) decl __attribute__((__unused__))
#   endif
#  else /* __GNUC__ >= 2 */
#   define SM_UNUSED(decl) decl
#  endif /* __GNUC__ >= 2 */
# endif /* SM_UNUSED */


/*
**  Turn on format string argument checking.
*/

#ifndef SM_CONF_FORMAT_TEST
# if __GNUC__ == 2 && __GNUC_MINOR__ >= 7
#  define SM_CONF_FORMAT_TEST	1
# else
#  define SM_CONF_FORMAT_TEST	0
# endif
#endif /* SM_CONF_FORMAT_TEST */

#ifndef PRINTFLIKE
# if SM_CONF_FORMAT_TEST
#  define PRINTFLIKE(x,y) __attribute__ ((__format__ (__printf__, x, y)))
# else
#  define PRINTFLIKE(x,y)
# endif
#endif /* ! PRINTFLIKE */

#ifndef SCANFLIKE
# if SM_CONF_FORMAT_TEST
#  define SCANFLIKE(x,y) __attribute__ ((__format__ (__scanf__, x, y)))
# else
#  define SCANFLIKE(x,y)
# endif
#endif /* ! SCANFLIKE */

#endif /* ! SM_CDEFS_H */
