/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: fs.h,v 1.6 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_FS_H
#define SM_FS_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/time.h"
#include "sm/pthread.h"

/*
**  File system definition.
**	Used to keep track of how much free space is available
**	on a file system in which one or more queue directories reside.
**
**  Each queue directory has an index which points to one entry in
**  the FileSys array. When a function needs to check whether there
**  is enough disk space, it checks this structure and the time stamp.
**  If the entry isn't "too old" and it indicates "ok" (enough space
**  available), the operation proceeds. Otherwise the entry is updated.
**
**  Problems:
**  - using this in QMGR means that CDB isn't transparent,
**  maybe CDB should have its own fs_ctx?
**  However, that wouldn't help because CDB is used by SMTPS and QMGR,
**  i.e., by different processes. It may work if CDB uses its own context
**  which is only updated by QMGR.
**  - dev_t doesn't work on WIN32
*/

typedef struct fs_ctx_S	fs_ctx_T, *fs_ctx_P;

sm_ret_T fs_ctx_open(uint _entries, fs_ctx_P *_pfs_ctx);
sm_ret_T fs_ctx_close(fs_ctx_P _fs_ctx);

sm_ret_T fs_new(fs_ctx_P _fs_ctx, const char *path, int *_pfs_idx);
sm_ret_T fs_getfree(fs_ctx_P _fs_ctx, uint _fs_idx, ulong *_pfs_kbfree);
sm_ret_T fs_chgfree(fs_ctx_P _fs_ctx, uint _fs_idx, long _fs_chg, ulong *_pfs_kbfree);

#define SM_IS_FS_CTX(fs_ctx) SM_REQUIRE((fs_ctx) != NULL)

#endif /* SM_FS_H */
