/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: pmfdef.h,v 1.4 2005/05/31 18:37:41 ca Exp $
 */

#ifndef PMFDEF_H
#define PMFDEF_H 1

/* pmilter (global) context */
typedef struct pmg_ctx_S	pmg_ctx_T, *pmg_ctx_P;

/* pmilter context per SMTP server */
typedef struct pmss_ctx_S	pmss_ctx_T, *pmss_ctx_P;

/* pmilter session context */
typedef struct pmse_ctx_S	pmse_ctx_T, *pmse_ctx_P;

/* pmilter application context */
typedef struct pmilter_S	pmilter_T, *pmilter_P;

/* macros that can be sent by the MTA to a pmilter */

#define PMM_END			0x0000	/* end of macro list */

#define PMM_SRVHOSTNAME		0x0001	/* hostname of server */

#define PMM_SEID		0x0010	/* session id */
#define PMM_CLIENT_RESOLVE	0x0011	/* result of client lookups */

#define PMM_TLS_VERSION		0x0020
#define PMM_TLS_CIPHER_SUITE	0x0021
#define PMM_TLS_CIPHER_BITS	0x0022
#define PMM_TLS_CERT_SUBJECT	0x0023
#define PMM_TLS_CERT_ISSUERT	0x0024

#define PMM_AUTH_TYPE		0x0030
#define PMM_AUTH_AUTHEN		0x0031
#define PMM_AUTH_AUTHOR		0x0032

#define PMM_MAIL_TAID		0x0040	/* transaction id */

#define PMM_DOT_MSGID		0x0080

/* stages when to send a macro */
#define PM_SMST_CONNECT		0
#define PM_SMST_EHLO		1
#define PM_SMST_MAIL		2
#define PM_SMST_RCPT		3
#define PM_SMST_DATA		4
#define PM_SMST_DOT		5
#define PM_SMST_MAX		6	/* max number of stages */
#define PM_MAX_MACROS		8	/* max. number of macro per stage */

#endif /* ! PMFDEF_H */
