/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: smarcnfdef.h,v 1.41 2005/08/17 23:39:32 ca Exp $
 */

#ifndef SM_SMARCNFDEF_H
#define SM_SMARCNFDEF_H 1

#include "sm/generic.h"
#include "sm/net.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-time.h"
#include "sm/mta.h"
#include "sm/cnf.h"
#include "sm/smardef.h"
#include "sm/smarcnf.h"
#include "sm/mcpcnfs.h"
#include "sm/logcnfdef.h"
#include "sm/greycnfdef.h"

#if SM_SMARCNFDEF
#define EXTERN
#else /* SM_SMARCNFDEF */
#define EXTERN extern
#endif /* SM_SMARCNFDEF */

EXTERN
sm_conf_definition_T const
smar_dns_flag_names[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "Use_TCP",		sm_conf_type_choice_value,
	DNS_TSK_USETCP,
	0, NULL, 0, NULL, NULL, NULL,
	"use TCP for connection to DNS server" },
{ SM_CONF_DEF_MAGIC, "Use_Connect",	sm_conf_type_choice_value,
	DNS_TSK_CONNECTUDP,
	0, NULL, 0, NULL, NULL, NULL,
	"use connect(2) even with UDP" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;

#define DNSBL_TEMPFAIL	0x01

#if 0
EXTERN
sm_conf_definition_T const
smar_dnsbl_flag_names[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "tempfail",	sm_conf_type_choice_value,
	DNSBL_TEMPFAIL	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;
#endif /* 0 */


EXTERN
sm_conf_definition_T
smar_dnsbl_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "domain",		sm_conf_type_string,
	offsetof(smar_cnfdnsbl_T, scdb_name),	0,	NULL,
	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL,	NULL,	NULL,	"DNS blocklist lookup domain" },

{ SM_CONF_DEF_MAGIC, "tag",		sm_conf_type_string,
	offsetof(smar_cnfdnsbl_T, scdb_tag),	0,	NULL,
	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL,	NULL,	NULL,	"DNS blocklist access map lookup tag" },

#if 0

	{ SM_CONF_DEF_MAGIC,
		/* name */
		/* type */
		/* offset  */
		/* size */
		/* default */
		/* flag */
		/* cont */
		/* chkf */
		/* chkd */
		/* description */
	},

{ SM_CONF_DEF_MAGIC, "reject_message",		sm_conf_type_string,
	offsetof(smar_cnfdnsbl_T, scdb_rejmsg),	0, NULL	},
{ SM_CONF_DEF_MAGIC, "tempfail_message",	sm_conf_type_string,
	offsetof(smar_cnfdnsbl_T, scdb_tmpmsg),	0, NULL	},
{ SM_CONF_DEF_MAGIC, "flags",		sm_conf_type_choice,
	offsetof(smar_cnfdnsbl_T, scbd_flags),	sizeof(uint32_t),
	NULL,	SM_CONF_FLAG_MULTIPLE,		smar_dnsbl_flag_names },
#endif /* 0 */

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;


EXTERN
sm_conf_definition_T
smar_dnsbls_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "",		sm_conf_type_section,
	offsetof(smar_cnf_T, smar_cnf_dnsbl), sizeof(smar_cnfdnsbl_T),
	NULL, 0,
	smar_dnsbl_defs,
	NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "", sm_conf_type_array_n,
	offsetof(smar_cnf_T, smar_cnf_dnsbl_n), sizeof(uint),
	NULL, 0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;


EXTERN
sm_conf_definition_T
smar_map_definitions[]
#if SM_MAPCNFDEF
=
{
	{
		SM_CONF_DEF_MAGIC,
		"map declaration",
		sm_conf_type_union,
		offsetof(smar_cnf_T, smar_cnf_mapdecl.mapdecl_maps),
		sizeof(mapspec_T),
		NULL,
		0,
		map_spec_defs,
		NULL,
		NULL,
		"maps"
	},

	{
		SM_CONF_DEF_MAGIC,
		"n",
		sm_conf_type_array_n,
		offsetof(smar_cnf_T, smar_cnf_mapdecl.mapdecl_n),
		sizeof(uint),
		NULL,
		0,
		map_spec_defs,
		NULL,
		NULL,
		"number of maps (implicit)"
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;

#if 0
EXTERN
sm_conf_definition_T
maps_spec_defs[]
#if SM_MAPCNFDEF
=
{
	{ SM_CONF_DEF_MAGIC, "map", sm_conf_type_array,
		0,	/* offset */
		0,	/* size (# of elements) */
		NULL,	/* default */
		SM_CONF_FLAG_MULTIPLE,
		smar_map_definitions,
		NULL,  NULL,
		"Map Declarations"
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;
#endif /* 0 */


EXTERN
sm_conf_definition_T const
smar_alias_flags[]
#if SM_SMARCNFDEF
=
{
#if 0
{ SM_CONF_DEF_MAGIC, "none",		sm_conf_type_choice_value,
	0,
	0, NULL, 0, NULL, NULL, NULL, "" },
#endif
{ SM_CONF_DEF_MAGIC, "localpart",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_LP,
	0, NULL, 0, NULL, NULL, NULL,
	"apply aliases to local part" },
{ SM_CONF_DEF_MAGIC, "local_domains",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_LD,
	0, NULL, 0, NULL, NULL, NULL,
	"apply aliases to local domains" },
{ SM_CONF_DEF_MAGIC, "all_domains",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_ALL,
	0, NULL, 0, NULL, NULL, NULL,
	"apply aliases to all domains" },

{ SM_CONF_DEF_MAGIC, "detail_plus",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DETPLUS,
	0, NULL, 0, NULL, NULL, NULL,
	"perform ++ matching" },
{ SM_CONF_DEF_MAGIC, "detail_star",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DETSTAR,
	0, NULL, 0, NULL, NULL, NULL,
	"perform +* matching" },
{ SM_CONF_DEF_MAGIC, "star",		sm_conf_type_choice_value,
	SMARCNF_FL_ALI_STAR,
	0, NULL, 0, NULL, NULL, NULL,
	"perform * matching" },
{ SM_CONF_DEF_MAGIC, "domain",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DOMAIN,
	0, NULL, 0, NULL, NULL, NULL,
	"perform @domain matching" },
{ SM_CONF_DEF_MAGIC, "dotsubdomain",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DOTSUBDOM,
	0, NULL, 0, NULL, NULL, NULL,
	"perform @.sub.domain matching" },
{ SM_CONF_DEF_MAGIC, "implicitly_match_detail",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_IMPLDET,
	0, NULL, 0, NULL, NULL, NULL,
	"implicitly match +detail without specifying +* or *"	},

{ SM_CONF_DEF_MAGIC, "replace_macros",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_MREPL,
	0, NULL, 0, NULL, NULL, NULL, "replace macros" },

{ SM_CONF_DEF_MAGIC, "preserve_domain",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_PD,
	0, NULL, 0, NULL, NULL, NULL, "preserve domain from key (LHS)" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;



EXTERN
sm_conf_definition_T
smar_alias_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "file",				sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_alias_fn),	0,
	SMAR_ALIASES_FILE,	0,	NULL,	NULL,	NULL,
	"filename of aliases map (including extension)"	},

{ SM_CONF_DEF_MAGIC, "flags",				sm_conf_type_choice,
	offsetof(smar_cnf_T, smar_cnf_alias_fl),	sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE,			smar_alias_flags,
	NULL,	NULL,
	"aliases lookup flags"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;

EXTERN
sm_conf_definition_T const
smar_lum_flags[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "localpart",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_LP,
	0, NULL, 0, NULL, NULL, NULL,
	"lookup only local part" },
{ SM_CONF_DEF_MAGIC, "local_domains",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_LD,
	0, NULL, 0, NULL, NULL, NULL,
	"lookup local domains" },
{ SM_CONF_DEF_MAGIC, "all_domains",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_ALL,
	0, NULL, 0, NULL, NULL, NULL,
	"lookup all domains" },

{ SM_CONF_DEF_MAGIC, "detail_plus",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DETPLUS,
	0, NULL, 0, NULL, NULL, NULL,
	"perform ++ matching" },
{ SM_CONF_DEF_MAGIC, "detail_star",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DETSTAR,
	0, NULL, 0, NULL, NULL, NULL,
	"perform +* matching" },
{ SM_CONF_DEF_MAGIC, "star",		sm_conf_type_choice_value,
	SMARCNF_FL_ALI_STAR,
	0, NULL, 0, NULL, NULL, NULL,
	"perform * matching" },
{ SM_CONF_DEF_MAGIC, "dotsubdomain",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_DOTSUBDOM,
	0, NULL, 0, NULL, NULL, NULL,
	"perform @.sub.domain matching" },
{ SM_CONF_DEF_MAGIC, "implicitly_match_detail",	sm_conf_type_choice_value,
	SMARCNF_FL_ALI_IMPLDET,
	0, NULL, 0, NULL, NULL, NULL,
	"implicitly match +detail without specifying +* or *"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;


EXTERN
sm_conf_definition_T
smar_lum_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "name",				sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_lum_name),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED, NULL,	NULL,	NULL,
	"name of local user map"	},

{ SM_CONF_DEF_MAGIC, "flags",				sm_conf_type_choice,
	offsetof(smar_cnf_T, smar_cnf_lum_fl),		sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE,			smar_lum_flags,
	NULL,	NULL,
	"local user map lookup flags"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;



EXTERN
sm_conf_definition_T
smar_mt_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "file",				sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_mt_fn),	0,
	SMAR_MT_NAME,	0,	NULL,	NULL,	NULL,
	"filename of mailertable file"	},

{ SM_CONF_DEF_MAGIC, "name",				sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_mt_name),	0,
	NULL,	0, NULL,	NULL,	NULL,
	"name of mailertable map"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;

EXTERN
sm_conf_definition_T
smar_access_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "file",				sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_access_fn),	0,
	SMAR_ACCESS_FILE,	0,	NULL,	NULL,	NULL,
	"filename of access map (including extension)"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;


EXTERN
sm_conf_definition_T
smar_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "nameserver",		sm_conf_type_argv,
	offsetof(smar_cnf_T, smar_cnf_nameservers),	SM_DNS_MAX_TSKS,
	NULL,	0,	NULL,	NULL,	NULL,
	"List of nameservers (IPv4 addresses)"	},

{ SM_CONF_DEF_MAGIC, "DNS_Flags",		sm_conf_type_choice,
	offsetof(smar_cnf_T, smar_cnf_dns_flags),	sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE,		smar_dns_flag_names,
	NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "DNS_timeout",		sm_conf_type_u32,
	offsetof(smar_cnf_T, smar_cnf_dns_timeout),	sizeof(uint),
	SM_XSTR(DNS_TIMEOUT),	0,	sm_conf_time_suffixes,
	NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "log_level",		sm_conf_type_u32,
	offsetof(smar_cnf_T, smar_cnf_loglevel),	sizeof(uint),
	SM_XSTR(SM_LOG_LEVEL),
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "log",			sm_conf_type_section,
	offsetof(smar_cnf_T, smar_cnf_log),	0,
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, sm_log_spec_defs,
	NULL,	NULL,
	SM_CNF_LOG	},

/* event thread options; enforce lower/upper limits? */
{ SM_CONF_DEF_MAGIC, EVTHR_CNF_MIN_THR,		sm_conf_type_u32,
	offsetof(smar_cnf_T, smar_cnf_minthr),	sizeof(uint),
	SM_XSTR(SMAR_CNF_MINTHR),	0,	NULL,	NULL,	NULL,
	EVTHR_COMM_MIN_THR },
{ SM_CONF_DEF_MAGIC, EVTHR_CNF_MAX_THR,		sm_conf_type_u32,
	offsetof(smar_cnf_T, smar_cnf_maxthr),	sizeof(uint),
	SM_XSTR(SMAR_CNF_MAXTHR),	0,	NULL,	NULL,	NULL,
	EVTHR_COMM_MAX_THR },
{ SM_CONF_DEF_MAGIC, EVTHR_CNF_MAX_FD,		sm_conf_type_u32,
	offsetof(smar_cnf_T, smar_cnf_maxfd),	sizeof(uint),
	SM_XSTR(SMAR_CNF_MAXFD),	0,	NULL,	NULL,	NULL,
	EVTHR_COMM_MAX_FD },

/*
{ SM_CONF_DEF_MAGIC, "local_user_map",		sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_lum_name),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"Map specifying valid local users/addresses"	},
*/

{ SM_CONF_DEF_MAGIC, "local_user_map", sm_conf_type_section,
	0, sizeof(smar_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, smar_lum_defs,
	NULL, NULL,
	"Map specifying valid local users/addresses"	},

{ SM_CONF_DEF_MAGIC, "dnsbl",		sm_conf_type_array,
	0, SM_MAX_DNSBL,
	NULL, SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_FLAT,
	smar_dnsbls_defs,
	NULL,	NULL,
	"DNS based blacklists"	},

{ SM_CONF_DEF_MAGIC, "greylisting", sm_conf_type_section,
	offsetof(smar_cnf_T, smar_cnf_grey), sizeof(smar_cnf_T),
	NULL, 0, greycnf_defs, NULL, NULL,
	"Greylisting options"	},

{ SM_CONF_DEF_MAGIC, "map",		sm_conf_type_array,
	0,	/* offset */
	0,	/* size (# of elements) */
	NULL,	/* default */
	SM_CONF_FLAG_MULTIPLE,
	smar_map_definitions,
	NULL,  NULL,
	"Map Declarations"	},

{ SM_CONF_DEF_MAGIC, "address_delimiter",		sm_conf_type_char,
	offsetof(smar_cnf_T, smar_cnf_addr_delim),	sizeof(uchar),
	"+",	0, 	NULL,	NULL,	NULL,
	"delimiter for address extensions in local part" },

{ SM_CONF_DEF_MAGIC, "aliases", sm_conf_type_section,
	0, sizeof(smar_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, smar_alias_defs,
	NULL, NULL,
	"aliases definition"  },

{ SM_CONF_DEF_MAGIC, "mailertable",		sm_conf_type_section,
	0, sizeof(smar_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, smar_mt_defs,
	NULL, NULL,
	"mailertable definition"  },

{ SM_CONF_DEF_MAGIC, "access_map",		sm_conf_type_section,
	0,	sizeof(smar_cnf_T),
	NULL, SM_CONF_FLAG_KEEP_DEFAULT,	smar_access_defs,
	NULL, NULL,
	"access map definition"  },

	MCP_DEFS(smar_cnf_T, smar_cnf)

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;

EXTERN
sm_conf_definition_T
smar_global_defs[]
#if SM_SMARCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "SMAR_socket",	sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_sock),	0,	smarsock,
	0,	NULL,	NULL,	NULL,
	"Address resolver server socket"	},
{ SM_CONF_DEF_MAGIC, "hostname",		sm_conf_type_string,
	offsetof(smar_cnf_T, smar_cnf_hostname),	0,	NULL,
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "smar", sm_conf_type_section,
	0, sizeof(smar_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, smar_defs,
	NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SMARCNFDEF */
;

#undef EXTERN

#endif /* SM_SMARCNFDEF_H */
