/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: test.c,v 1.7 2004/08/26 23:18:37 ca Exp $")

#include "sm/sysexits.h"
#include "sm/test.h"
#include <stdio.h>

/*
**  Abstractions for writing test programs.
*/

extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;

int SmTestIndex;
int SmTestNumErrors;
bool SmTestVerbose;
int SmTestVerbosity = 0;
bool SmTestRootOk = false;

static char Help[] = "\
%s [-h] [-v]\n\
\n\
%s\n\
\n\
-h		Display this help information.\n\
-v		Verbose output.\n\
";

static char Usage[] = "\
Usage: %s [-h] [-v]\n\
Use %s -h for help.\n\
";

/*
**  SM_TEST_BEGIN -- initialize test system.
**
**	Parameters:
**		argc -- argument counter.
**		argv -- argument vector.
**		testname -- description of tests.
**
**	Results:
**		none.
*/

void
sm_test_begin(int argc, char **argv, char *testname)
{
	int c;
	uid_t uid;

	SmTestIndex = 0;
	SmTestNumErrors = 0;
	SmTestVerbose = false;
	opterr = 0;
	uid = geteuid();
	if (uid == 0 && !SmTestRootOk)
	{
		(void) fprintf(stderr,
			"I'm sorry, Dave, I'm afraid I can't do that\n(running as root)\n");
		exit(EX_USAGE);
	}
	while ((c = getopt(argc, argv, "vVh")) != -1)
	{
		switch (c)
		{
		  case 'v':
			SmTestVerbose = true;
			break;
		  case 'V':
			++SmTestVerbosity;
			break;
		  case 'h':
			(void) fprintf(stderr, Help, argv[0], testname);
			exit(0);
		  default:
/*
**  On Linux this is somehow triggered when the caller uses:
	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test");

**  This sequence seems to work:
	sm_test_begin(argc, argv, "test");
	argc -= optind;
	argv += optind;
*/
			(void) fprintf(stderr,
				"Unknown command line option -%c\n", optopt);
			(void) fprintf(stderr, Usage, argv[0], argv[0]);
			exit(EX_USAGE);
		}
	}
}

/*
**  SM_TEST -- single test.
**
**	Parameters:
**		success -- did test succeeed?
**		expr -- expression that has been evaluated.
**		filename -- guess...
**		lineno -- line number.
**
**	Results:
**		value of success.
*/

bool
sm_test(bool success, char *expr, char *filename, int lineno)
{
	++SmTestIndex;
	if (SmTestVerbose)
		(void) fprintf(stderr, "%d..", SmTestIndex);
	if (!success)
	{
		++SmTestNumErrors;
		if (!SmTestVerbose)
			(void) fprintf(stderr, "%d..", SmTestIndex);
		(void) fprintf(stderr,
			"bad! %s:%d %s\n", filename, lineno, expr);
	}
	else
	{
		if (SmTestVerbose)
			(void) fprintf(stderr, "ok\n");
	}
	return success;
}

/*
**  SM_TEST_END -- end of test system.
**
**	Parameters:
**		none.
**
**	Results:
**		number of errors.
*/

int
sm_test_end(void)
{
	(void) fprintf(stderr, "%d of %d tests completed successfully\n",
		SmTestIndex - SmTestNumErrors, SmTestIndex);
	if (SmTestNumErrors != 0)
		(void) fprintf(stderr,
			"*** %d error%s in test! ***\n",
			SmTestNumErrors,
			SmTestNumErrors > 1 ? "s" : "");

	return SmTestNumErrors;
}
