/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm-conf-prterr.c,v 1.3 2005/10/13 18:32:28 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-prt.h"

/*
**  SM_PRT_CONFERR -- Show configuration error
**
**	Parameters:
**		fn -- filename of configuration file
**		smc -- configuration context
**		err -- error number
**
**	Returns:
**		none.
*/

void
sm_prt_conferr(const char *fn, sm_conf_T *smc, int err)
{
	char buf[256];
	char const *e;

	e = NULL;
	sm_io_fprintf(smioerr, "%s: %s\n", fn,
		sm_conf_strerror(err, buf, sizeof buf));
	while ((e = sm_conf_syntax_error(smc, e)) != NULL)
		sm_io_fprintf(smioerr, "%s\n", e);
	return;
}
