/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fskip.c,v 1.4 2005/06/02 19:00:36 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/memops.h"

/*
**  SM_IO_FSKIP -- skip n chars from the buffer of the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		n -- chars to skip
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fskip(sm_file_T *fp, size_t l)
{
	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);

	if (f_r(*fp) < 0)
		return sm_error_temp(SM_EM_IO, EINVAL);
	if ((size_t)f_r(*fp) < l)
		return sm_error_temp(SM_EM_IO, EINVAL);
	f_r(*fp) -= l;
	f_p(*fp) += l;
	return SM_SUCCESS;

}
