/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: genconfpath.c,v 1.4 2005/10/25 23:33:41 ca Exp $")

#include "sm/error.h"
#include "sm/assert.h"
#include "sm/string.h"
#include "sm/cstr.h"
#include "sm/confsetpath.h"

/*
**  SM_GEN_CONF_PATH -- generate absolute path for filename
**  If no filename is provided in the configuration (cnfname)
**  then use the default (dflt) but prepend the directory in which the
**  configuration file was found (cnfdir).
**  The resulting pathname is assigned to abspath.
**
**	Parameters:
**		cnfdir -- base directory of configuration file
**		cnfname -- pathname set in configuration file
**		dflt -- default value
**		pabspath -- path to use (output)
**		pcnfabspath -- assign allocated storage to this (output)
**
**	Returns:
**		usual return code
*/

sm_ret_T
sm_gen_conf_path(const char *cnfdir, const char *cnfname, const char *dflt, const char **pabspath, char **pcnfabspath)
{
	char *cnfabspath;

	SM_REQUIRE(pabspath != NULL);
	SM_REQUIRE(pcnfabspath != NULL);
	*pcnfabspath = NULL;
	if (cnfname == NULL && dflt == NULL)
		*pabspath = NULL;
	else if (cnfname == NULL || *cnfname != '/')
	{
		const char *cnf;

		cnf = (cnfname == NULL) ? dflt : cnfname;
		SM_ASSERT(cnf != NULL);
		if (cnfdir != NULL && *cnfdir != '\0')
		{
			size_t mpl, sl;

			mpl = strlen(cnfdir) + strlen(cnf) + 1;
			cnfabspath = (char *) sm_malloc(mpl);
			if (cnfabspath == NULL)
				return sm_err_temp(ENOMEM);
			sl = strlcpy(cnfabspath, cnfdir, mpl);
			SM_ASSERT(sl < mpl);
			sl = strlcat(cnfabspath, cnf, mpl);
			SM_ASSERT(sl < mpl);
			*pabspath = cnfabspath;

			/* pcnfabspath not really used anywhere?? */
			*pcnfabspath = cnfabspath;
		}
		else
			*pabspath = cnf;
	}
	else
		*pabspath = cnfname;
	return SM_SUCCESS;
}
