/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbgetstr.c,v 1.11 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"
#include "sm/rcb.h"

/*
**  SM_RCB_GETSTR -- Read into str object from rcb (n bytes).
**
**	Parameters:
**		rcb -- sm_rcb_P object to read from.
**		str -- sm_str_P object to read into (append).
**		n -- number of bytes to copy (aligned to 4 bytes).
**
**	Returns:
**		usual sm_error code; SM_E_OVFLW_NS
**
**	Last code review: 2005-03-29 05:32:56
**	Last code change:
*/

sm_ret_T
sm_rcb_getstr(sm_rcb_P rcb, sm_str_P str, uint n)
{
	uint la;

	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
	SM_ASSERT(str != NULL);
	la = SM_ALIGN4(n);
	if (rcb->sm_rcb_rw + la > rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	if (la + str->sm_str_len > str->sm_str_max)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	sm_memcpy((void *) (str->sm_str_base + str->sm_str_len),
		rcb->sm_rcb_base + rcb->sm_rcb_rw, n);
	str->sm_str_len += n;
	rcb->sm_rcb_rw += la;
	return SM_SUCCESS;
}
