/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_stop.c,v 1.8 2005/08/17 20:05:22 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/sysexits.h"
#include "sm/signal.h"
#include "sm/io.h"
#include "pmilter.h"

#if SM_USE_PMILTER

/*
**  SM_PMILT_STOP -- stop PMILTER
**
**	Parameters:
**		pmg_ctx -- pmilter (library) context
**
**	Returns:
**		usual sm_error code
*/

/* should we pass type of shutdown? immediate, normal, ...? */
sm_ret_T
sm_pmilt_stop(pmg_ctx_P pmg_ctx)
{
	uint u;
	sm_ret_T ret;

	SM_REQUIRE(pmg_ctx != NULL);
	if (pmg_ctx->pmg_state < PMILT_ST_INIT0 ||
	    pmg_ctx->pmg_state >= PMILT_ST_STOPPING)
		return SM_SUCCESS;

	/*
	**  How to properly shut down the system?
	**  In which order? Which tasks need to be called for termination?
	*/

	CLOSE_FD(pmg_ctx->pmg_sslfd);

	if (pmg_ctx->pmg_ev_ctx != NULL)
		ret = evthr_stop(pmg_ctx->pmg_ev_ctx);
		/* complain on error? */

	for (u = 0; u < SM_ARRAY_SIZE(pmg_ctx->pmg_sctx); u++)
	{
		(void) sm_pmss_free(pmg_ctx->pmg_sctx[u]);
		pmg_ctx->pmg_sctx[u] = NULL;
	}

	/* destroy mutex first? */
	ret = thr_stop();
	if (sm_is_err(ret))
		goto error;

#if 0
	pmg_ctx->pmg_status = PMILTER_ST_STOPPED;
#endif

	(void) pthread_mutex_destroy(&(pmg_ctx->pmg_mutex));
	return SM_SUCCESS;

  error:
	return ret;
}
#endif /* SM_USE_PMILTER */
