/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rictx.c,v 1.16 2005/03/16 01:20:21 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/ibdb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/bhtable.h"
#include "sm/rdibdb.h"
#include "sm/qmibdb.h"

#if SM_TEST_PRT
#include "sm/io.h"
#endif

/* XXX HACK XXX */
#define RI_BHTSIZE	(32 * 1024)
#define RI_BHTMAX	(64 * 1024)

/*
**  QM_RI_CTX_FREE -- free Recover-IBDB context
**
**	Parameters:
**		ri_ctx -- Recover-IBDB context
**
**	Returns:
**		SM_SUCCESS
**
**	Last code review: 2005-03-16 00:17:11
**	Last code change: 2005-03-16 00:16:22
*/

sm_ret_T
qm_ri_ctx_free(ri_ctx_P ri_ctx)
{
	if (ri_ctx == NULL)
		return SM_SUCCESS;
	if (ri_ctx->rix_bht_ta != NULL)
		bht_destroy(ri_ctx->rix_bht_ta, ibdb_ta_free, NULL);
	if (ri_ctx->rix_bht_rcpt != NULL)
		bht_destroy(ri_ctx->rix_bht_rcpt, ibdb_rcpt_free, NULL);
	(void) aq_ta_free(ri_ctx->rix_aq_ta);
	(void) aq_rcpt_free(ri_ctx->rix_aq_rcpt);

	/* HACK FOR TESTING! */
	if (ri_ctx->rix_qmgr_ctx != NULL)
		edb_reql_free(ri_ctx->rix_qmgr_ctx->qmgr_edb,
			&(ri_ctx->rix_edb_req_hd));
	else
		edb_reql_free(NULL, &(ri_ctx->rix_edb_req_hd));
	sm_free_size(ri_ctx, sizeof(*ri_ctx));
	return SM_SUCCESS;
}

/*
**  QM_RI_CTX_NEW -- create new Recover-IBDB context
**
**	Parameters:
**		qmgr_ctx -- QMGR context (can be NULL for test prgs)
**		pri_ctx -- (pointer to) Recover-IBDB context (output)
**
**	Returns:
**		usual sm_error code; ENOMEM,
**
**	Side Effects: none on error
**
**	Last code review: 2005-03-16 00:14:47
**	Last code change: 2005-03-16 00:13:36
*/

sm_ret_T
qm_ri_ctx_new(qmgr_ctx_P qmgr_ctx, ri_ctx_P *pri_ctx)
{
	sm_ret_T ret;
	bht_P bht, bhr;
	ri_ctx_P ri_ctx;

	SM_REQUIRE(pri_ctx != NULL);
	bht = NULL;
	bhr = NULL;
	ri_ctx = (ri_ctx_P) sm_zalloc(sizeof(*ri_ctx));
	if (ri_ctx == NULL)
		goto enomem;
	ri_ctx->rix_qmgr_ctx = qmgr_ctx;
	EDBREQL_INIT(&(ri_ctx->rix_edb_req_hd));
	bht = bht_new(RI_BHTSIZE, RI_BHTMAX);
	if (bht == NULL)
		goto enomem;
	ri_ctx->rix_bht_ta = bht;
	bhr = bht_new(RI_BHTSIZE, RI_BHTMAX);
	if (bhr == NULL)
		goto enomem;
	ri_ctx->rix_bht_rcpt = bhr;

	ret = aq_ta_new(&(ri_ctx->rix_aq_ta));
	if (sm_is_err(ret))
		goto error;
	ret = aq_rcpt_new(&(ri_ctx->rix_aq_rcpt));
	if (sm_is_err(ret))
		goto error;

	*pri_ctx = ri_ctx;
	return SM_SUCCESS;

  enomem:
	ret = sm_error_temp(SM_EM_Q_RDIBDB, ENOMEM);
  error:
	if (bht != NULL)
		bht_destroy(bht, NULL, NULL);
	if (bhr != NULL)
		bht_destroy(bhr, NULL, NULL);
	if (ri_ctx != NULL)
	{
		aq_ta_free(ri_ctx->rix_aq_ta);
		aq_rcpt_free(ri_ctx->rix_aq_rcpt);
		sm_free_size(ri_ctx, sizeof(*ri_ctx));
	}
	*pri_ctx = NULL;
	return ret;
}
