#!/bin/sh
# $Id: t-mapaddr-2.sh,v 1.2 2005/07/05 17:20:49 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test lookup of addresses including replacements (${macro})
# Uses t-mapaddrr-0, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

BDBIN="bdb3"
BDB="bdb3.db"
OUT=out3
CMP=cmp3
OK=ok3
DIFF=diff3
ERRS=0

# data for map
cat > ${BDBIN} <<EOF
Tag:other.domain	rhs-Tag:user-\${user}-detail-\${detail}-other.domain
Tag:user2++@other.domain	rhs-Tag:user2-plus-\${detail}-other.domain
Tag:user2+*@other.domain	rhs-Tag:user2-star-\${detail}-other.domain
Tag:user3*@other.domain	rhs-Tag:user3-ext-\${extension}-other.domain
Tag:user4*@.tld4	rhs-Tag:user-\${user}-ext-\${extension}-sub-\${subdomain}.tld4
Tag:user5*@.tld5	rhs-Tag:user-\${user}-ext-\${extension}@\${domain}
alias+detail	rhs-alias-detail
alias++	rhs-alias-plus
alias+*	rhs-alias-star
alias	rhs-alias
virt+detail@vhost.domain	rhs-virt-detail-vhost.domain
virt++@vhost.domain	rhs-virt-plus-\${detail}-vhost.domain
virt+*@vhost.domain	rhs-virt-star-\${detail}-vhost.domain
virt@vhost.domain	rhs-virt/%0-vhost.domain?
nodetail@vhost.domain	rhs-nodetail\${delim}\${detail}-vhost.domain?
vdom+detail@.domain	rhs-vdom-detail-.domain
vdom++@.domain	rhs-vdom-delimplus-\${detail}@sub-\${subdomain}.domain
vdom+*@.domain	rhs-vdom-delimstar-\${detail}@sub-\${subdomain}.domain
vdom@.domain	rhs-vdom-\${subdomain}.domain
vlocal+detail@	rhs-vlocal-detail-@
vlocal++@	rhs-vlocal-plus-@
vlocal+*@	rhs-vlocal-star-@
vlocal@	rhs-virt-@
EOF

# create map
rm -f ${BDB}
./t-mm -t'	' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

for P in ./t-mapaddrr-0 # ./t-mapaddr-0
do

# test full lookup with replacements
${P} -m >${OUT} 2>&1 <<EOF
tag:user2:isdetail:other.domain
tag:user2::other.domain
tag:isuser:thisdetail:other.domain
tag:isuser::other.domain
tag:user3:isdetail:other.domain
tag:user3:N:other.domain
tag:user4:isdetail:sld.tld4
tag:user5:isdetail5:sld.tld5
N:vdom:N:subv.domain
N:vdom:isdetail:subv.domain
N:vdom::subv.domain
EOF

cat >${OK} <<EOF
ret=1, rhs='rhs-Tag:user2-plus-isdetail-other.domain'
ret=1, rhs='rhs-Tag:user2-star--other.domain'
ret=2, rhs='rhs-Tag:user-isuser-detail-thisdetail-other.domain'
ret=2, rhs='rhs-Tag:user-isuser-detail--other.domain'
ret=1, rhs='rhs-Tag:user3-ext-+isdetail-other.domain'
ret=1, rhs='rhs-Tag:user3-ext--other.domain'
ret=3, rhs='rhs-Tag:user-user4-ext-+isdetail-sub-sld.tld4'
ret=3, rhs='rhs-Tag:user-user5-ext-+isdetail5@sld.tld5'
ret=1, rhs='rhs-vdom-subv.domain'
ret=2, rhs='rhs-vdom-delimplus-isdetail@sub-subv.domain'
ret=2, rhs='rhs-vdom-delimstar-@sub-subv.domain'
EOF

## vdom+*@.domain	rhs-vdom-delimstar-\${detail}@sub-${subdomain}.domain

grep -v ' tests completed ' ${OUT} > ${CMP}

diff ${CMP} ${OK} > ${DIFF}
if test $? != 0
then
  echo errors:
  cat ${DIFF}
  ERRS=`expr ${ERRS} + 1 `
fi


done

exit ${ERRS}
