#!/bin/sh
# $Id: t-id-0.sh,v 1.5 2005/07/18 17:01:42 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test passing id to a program
# depends on implementation of servid!
# ----------------------------------------
#
test -s stop && exit 1

ERRS=0
OUT=mcp.out
RPLY=id.out
PIDS=pids
CONF=id.conf
SOCK=sock
VERBOSE=false
SD=`dirname $0`
. ${SD}/../check2/user.sh

# don't set this too high: on a slow system t-id might terminate before
# mcp started all processes
PROCS=3

if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

rm -f ${PIDS} ${OUT} ${SOCK} ${RPLY}

cat > ${CONF} <<EOF
idtest {
	pass_id = "-i";
	start_action = wait;
	min_processes = ${PROCS};
	max_processes = 8;
	user = ${USER};
	path = ./t-id;
	arguments = "t-id -o ${RPLY}";
}
EOF

./mcp -t -d ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}
sleep 1

i=0
while test ! -s ${RPLY}
do
  i=`expr ${i} + 1`
  test ${i} -ge 3 && break
  sleep 1
done

L=`wc -l < ${RPLY}`
if test X"${L}" = X
then
  echo ${RPLY} is empty?
  ERRS=`expr ${ERRS} + 1 `
else
if test ${L} -ne ${PROCS}
then
  ERRS=`expr ${ERRS} + 1 `
  echo ${L} != ${PROCS}
else

# are all ids used?
# note: this test could fail if the output is mixed up...
#i=0
# set to initial id value (depends on servid)
i=1
# only if i = 1
PROCS=`expr ${PROCS} + 1 `

while test ${i} -lt ${PROCS}
do
  grep "^id=${i}, " ${RPLY} >/dev/null || ERRS=`expr ${ERRS} + 1 `
  i=`expr ${i} + 1 `
done

fi
fi

for i in `cat ${PIDS}`
do
  kill ${i}
done

exit ${ERRS}
