/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-init-0.c,v 1.1 2005/08/14 06:33:52 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/heap.h"
#include "sm/test.h"
#include "sm/maps.h"
#include "sm/map.h"
#include "sm/mapclasses.h"
#include "sm/hostname.h"
#include "sm/bhtable.h"
#include "sm/io.h"
#include "sm/smardef.h"
#include "smar.h"
#include "t-init.h"

extern int Loglevel;

/*
**   T_SMAR_0_INIT -- Initialize smar_ctx
**	See smar_init1(), this is the part of it that is necessary for
**	checking "protected aliases".
**
**	Parameters:
**		smar_ctx -- SMAR context
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
t_smar_0_init(smar_ctx_P smar_ctx, uint iflags)
{
	sm_ret_T ret;
	sm_cstr_P mtype, mname;

	/* clear out data */
	sm_memzero(smar_ctx, sizeof(*smar_ctx));

	ret = sm_myhostname(&(smar_ctx->smar_hostname));
	if (sm_is_err(ret))
		goto error;

	ret = sm_log_create(NULL, &(smar_ctx->smar_lctx), NULL);
	if (sm_is_err(ret))
		goto error;
	ret = sm_log_setfp_fd(smar_ctx->smar_lctx, smiolog, SMIOLOG_FILENO);
	if (sm_is_err(ret))
		goto error;
	ret = sm_log_setdebuglevel(smar_ctx->smar_lctx, Loglevel);
	if (sm_is_err(ret))
		goto error;

	ret = sm_maps_init(&(smar_ctx->smar_maps));
	if (smar_ctx->smar_maps == NULL)
	{
		ret = sm_error_temp(SM_EM_AR, ENOMEM);
		goto error;
	}
	ret = sm_maps_create(smar_ctx->smar_maps);
	if (sm_is_err(ret))
		goto error;

#define SMAR_MT_TYPE	"bhtable"
#define SMAR_MT_NAME	"mt"

	if (SM_IS_FLAG(iflags, TSMARI_FL_MT))
	{
		mtype = sm_cstr_scpyn0((const uchar *)SMAR_MT_TYPE,
				strlen(SMAR_MT_TYPE));
		if (mtype == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		mname = sm_cstr_scpyn0((const uchar *)SMAR_MT_NAME,
				strlen(SMAR_MT_NAME));
		if (mname == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		smar_ctx->smar_mt_map = NULL;

		/* must be set for smar_mt_init */
		smar_ctx->sm_magic = SM_SMAR_CTX_MAGIC;
		ret = sm_map_open(smar_ctx->smar_maps, mname, mtype, 0, NULL
				, SMAP_MODE_RDONLY, &(smar_ctx->smar_mt_map)
				, SMPO_HASH_NELEM, 1023, SMPO_MAX_ELEM, 0
				, SMPO_INIT_CB, smar_mt_init, smar_ctx
				, SMPO_END);
		SM_CSTR_FREE(mname);
		SM_CSTR_FREE(mtype);
		if (sm_is_err(ret))
		{
SMAR_LEV_DPRINTF(0, (SMAR_DEBFP, "sev=ERROR, func=smar_init, open_mt=%x\n", ret));
			smar_ctx->smar_mt_map = NULL;
			goto error;
		}
	}

	if (SM_IS_FLAG(iflags, TSMARI_FL_ALIAS))
	{
		mtype = sm_cstr_scpyn0((const uchar *)SMAR_ALIASES_TYPE,
				strlen(SMAR_ALIASES_TYPE));
		if (mtype == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		mname = sm_cstr_scpyn0((const uchar *)SMAR_ALIASES_NAME,
				strlen(SMAR_ALIASES_NAME));
		if (mname == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		smar_ctx->smar_aliases = NULL;
		ret = sm_map_open(smar_ctx->smar_maps, mname, mtype, 0,
				SMAR_ALIASES_FILE, SMAP_MODE_RDONLY,
				&(smar_ctx->smar_aliases), SMPO_END);
		SM_CSTR_FREE(mname);
		SM_CSTR_FREE(mtype);
		/* ignore errors for now, the map is optional... */
		if (sm_is_err(ret))
		{
SMAR_LEV_DPRINTF(0, (SMAR_DEBFP, "smar_init: open_aliases=%x\n", ret));
			smar_ctx->smar_aliases = NULL;
#if 0
			goto error;
#endif /* 0 */
		}
	}

	if (SM_IS_FLAG(iflags, TSMARI_FL_ACC))
	{
		mtype = sm_cstr_scpyn0((const uchar *)SMAR_ACCESS_TYPE,
				strlen(SMAR_ACCESS_TYPE));
		if (mtype == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		mname = sm_cstr_scpyn0((const uchar *)SMAR_ACCESS_NAME,
				strlen(SMAR_ACCESS_NAME));
		if (mname == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		smar_ctx->smar_access = NULL;
		ret = sm_map_open(smar_ctx->smar_maps, mname, mtype, 0,
				SMAR_ACCESS_FILE, SMAP_MODE_RDONLY,
				&(smar_ctx->smar_access), SMPO_END);
		SM_CSTR_FREE(mname);
		SM_CSTR_FREE(mtype);
	}
#define MAPC_STYPE	"strmap"

	if (SM_IS_FLAG(iflags, TSMARI_FL_STR))
	{
		mtype = sm_cstr_scpyn0((const uchar *)MAPC_STYPE,
				strlen(MAPC_STYPE));
		if (mtype == NULL)
		{
			ret = sm_error_temp(SM_EM_AR, ENOMEM);
			goto error;
		}
		smar_ctx->smar_strmaptype = SM_CSTR_DUP(mtype);
		mtype = NULL;
	}

	smar_ctx->smar_cnf.smar_cnf_addr_delim = '+';
	smar_ctx->sm_magic = SM_SMAR_CTX_MAGIC;
	return ret;

  error:
	smar_ctx->sm_magic = SM_MAGIC_NULL;
	return ret;
}

#if 0
	sm_ret_T ret;
	sm_cstr_P mtype, mname;

	/* clear out data */
	sm_memzero(smar_ctx, sizeof(*smar_ctx));

	ret = sm_myhostname(&(smar_ctx->smar_hostname));
	if (sm_is_err(ret))
		goto error;

	ret = sm_maps_init(&(smar_ctx->smar_maps));
	if (smar_ctx->smar_maps == NULL)
	{
		ret = sm_error_temp(SM_EM_AR, ENOMEM);
		goto error;
	}
	ret = sm_bdb_class_create(smar_ctx->smar_maps);
	if (sm_is_err(ret))
		goto error;
	ret = sm_bht_class_create(smar_ctx->smar_maps);
	if (sm_is_err(ret))
		goto error;
#define SMAR_MT_TYPE	"bhtable"
#define SMAR_MT_NAME	"mt"

	mtype = sm_cstr_scpyn0((const uchar *)SMAR_MT_TYPE,
			strlen(SMAR_MT_TYPE));
	if (mtype == NULL)
	{
		ret = sm_error_temp(SM_EM_AR, ENOMEM);
		goto error;
	}
	mname = sm_cstr_scpyn0((const uchar *)SMAR_MT_NAME,
			strlen(SMAR_MT_NAME));
	if (mname == NULL)
	{
		ret = sm_error_temp(SM_EM_AR, ENOMEM);
		goto error;
	}
	smar_ctx->smar_mt_map = NULL;
	ret = sm_map_open(smar_ctx->smar_maps, mname, mtype, 0, NULL
			, SMAP_MODE_RDONLY, &(smar_ctx->smar_mt_map)
			, SMPO_HASH_NELEM, 1023, SMPO_MAX_ELEM, 0, SMPO_END);
	SM_CSTR_FREE(mname);
	SM_CSTR_FREE(mtype);
	if (sm_is_err(ret))
	{
SMAR_LEV_DPRINTF(0, (SMAR_DEBFP, "sev=ERROR, func=smar_init, open_mt=%x\n", ret));
		smar_ctx->smar_mt_map = NULL;
		goto error;
	}

	mtype = sm_cstr_scpyn0((const uchar *)SMAR_ALIASES_TYPE,
			strlen(SMAR_ALIASES_TYPE));
	if (mtype == NULL)
	{
		ret = sm_error_temp(SM_EM_AR, ENOMEM);
		goto error;
	}
	mname = sm_cstr_scpyn0((const uchar *)SMAR_ALIASES_NAME,
			strlen(SMAR_ALIASES_NAME));
	if (mname == NULL)
	{
		ret = sm_error_temp(SM_EM_AR, ENOMEM);
		goto error;
	}
	smar_ctx->smar_aliases = NULL;
	ret = sm_map_open(smar_ctx->smar_maps, mname, mtype, 0,
			SMAR_ALIASES_FILE, SMAP_MODE_RDONLY,
			&(smar_ctx->smar_aliases), SMPO_END);
	SM_CSTR_FREE(mname);
	SM_CSTR_FREE(mtype);
	/* ignore errors for now, the map is optional... */
	if (sm_is_err(ret))
	{
SMAR_LEV_DPRINTF(0, (SMAR_DEBFP, "smar_init: open_aliases=%x\n", ret));
		smar_ctx->smar_aliases = NULL;
#if 0
		goto error;
#endif /* 0 */
	}

	smar_ctx->sm_magic = SM_SMAR_CTX_MAGIC;
	return ret;

  error:
	smar_ctx->sm_magic = SM_MAGIC_NULL;
	return ret;
}
#endif
