# aclocal.m4 generated automatically by aclocal 1.5

# Copyright 1996, 1997, 1998, 1999, 2000, 2001
# Free Software Foundation, Inc.
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 5

# There are a few dirty hacks below to avoid letting `AC_PROG_CC' be
# written in clear, in which case automake, when reading aclocal.m4,
# will think it sees a *use*, and therefore will trigger all it's
# C support machinery.  Also note that it means that autoscan, seeing
# CC etc. in the Makefile, will ask for an AC_PROG_CC use...


# We require 2.13 because we rely on SHELL being computed by configure.
AC_PREREQ([2.13])

# AC_PROVIDE_IFELSE(MACRO-NAME, IF-PROVIDED, IF-NOT-PROVIDED)
# -----------------------------------------------------------
# If MACRO-NAME is provided do IF-PROVIDED, else IF-NOT-PROVIDED.
# The purpose of this macro is to provide the user with a means to
# check macros which are provided without letting her know how the
# information is coded.
# If this macro is not defined by Autoconf, define it here.
ifdef([AC_PROVIDE_IFELSE],
      [],
      [define([AC_PROVIDE_IFELSE],
              [ifdef([AC_PROVIDE_$1],
                     [$2], [$3])])])


# AM_INIT_AUTOMAKE(PACKAGE,VERSION, [NO-DEFINE])
# ----------------------------------------------
AC_DEFUN([AM_INIT_AUTOMAKE],
[AC_REQUIRE([AC_PROG_INSTALL])dnl
# test to see if srcdir already configured
if test "`CDPATH=:; cd $srcdir && pwd`" != "`pwd`" &&
   test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run \"make distclean\" there first])
fi

# Define the identity of the package.
PACKAGE=$1
AC_SUBST(PACKAGE)dnl
VERSION=$2
AC_SUBST(VERSION)dnl
ifelse([$3],,
[AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package])])

# Autoconf 2.50 wants to disallow AM_ names.  We explicitly allow
# the ones we care about.
ifdef([m4_pattern_allow],
      [m4_pattern_allow([^AM_[A-Z]+FLAGS])])dnl

# Autoconf 2.50 always computes EXEEXT.  However we need to be
# compatible with 2.13, for now.  So we always define EXEEXT, but we
# don't compute it.
AC_SUBST(EXEEXT)
# Similar for OBJEXT -- only we only use OBJEXT if the user actually
# requests that it be used.  This is a bit dumb.
: ${OBJEXT=o}
AC_SUBST(OBJEXT)

# Some tools Automake needs.
AC_REQUIRE([AM_SANITY_CHECK])dnl
AC_REQUIRE([AC_ARG_PROGRAM])dnl
AM_MISSING_PROG(ACLOCAL, aclocal)
AM_MISSING_PROG(AUTOCONF, autoconf)
AM_MISSING_PROG(AUTOMAKE, automake)
AM_MISSING_PROG(AUTOHEADER, autoheader)
AM_MISSING_PROG(MAKEINFO, makeinfo)
AM_MISSING_PROG(AMTAR, tar)
AM_PROG_INSTALL_SH
AM_PROG_INSTALL_STRIP
# We need awk for the "check" target.  The system "awk" is bad on
# some platforms.
AC_REQUIRE([AC_PROG_AWK])dnl
AC_REQUIRE([AC_PROG_MAKE_SET])dnl
AC_REQUIRE([AM_DEP_TRACK])dnl
AC_REQUIRE([AM_SET_DEPDIR])dnl
AC_PROVIDE_IFELSE([AC_PROG_][CC],
                  [_AM_DEPENDENCIES(CC)],
                  [define([AC_PROG_][CC],
                          defn([AC_PROG_][CC])[_AM_DEPENDENCIES(CC)])])dnl
AC_PROVIDE_IFELSE([AC_PROG_][CXX],
                  [_AM_DEPENDENCIES(CXX)],
                  [define([AC_PROG_][CXX],
                          defn([AC_PROG_][CXX])[_AM_DEPENDENCIES(CXX)])])dnl
])

#
# Check to make sure that the build environment is sane.
#

# serial 3

# AM_SANITY_CHECK
# ---------------
AC_DEFUN([AM_SANITY_CHECK],
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftest.file
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftest.file 2> /dev/null`
   if test "$[*]" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftest.file`
   fi
   rm -f conftest.file
   if test "$[*]" != "X $srcdir/configure conftest.file" \
      && test "$[*]" != "X conftest.file $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "$[2]" = conftest.file
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
AC_MSG_RESULT(yes)])


# serial 2

# AM_MISSING_PROG(NAME, PROGRAM)
# ------------------------------
AC_DEFUN([AM_MISSING_PROG],
[AC_REQUIRE([AM_MISSING_HAS_RUN])
$1=${$1-"${am_missing_run}$2"}
AC_SUBST($1)])


# AM_MISSING_HAS_RUN
# ------------------
# Define MISSING if not defined so far and test if it supports --run.
# If it does, set am_missing_run to use it, otherwise, to nothing.
AC_DEFUN([AM_MISSING_HAS_RUN],
[AC_REQUIRE([AM_AUX_DIR_EXPAND])dnl
test x"${MISSING+set}" = xset || MISSING="\${SHELL} $am_aux_dir/missing"
# Use eval to expand $SHELL
if eval "$MISSING --run true"; then
  am_missing_run="$MISSING --run "
else
  am_missing_run=
  am_backtick='`'
  AC_MSG_WARN([${am_backtick}missing' script is too old or missing])
fi
])

# AM_AUX_DIR_EXPAND

# For projects using AC_CONFIG_AUX_DIR([foo]), Autoconf sets
# $ac_aux_dir to `$srcdir/foo'.  In other projects, it is set to
# `$srcdir', `$srcdir/..', or `$srcdir/../..'.
#
# Of course, Automake must honor this variable whenever it calls a
# tool from the auxiliary directory.  The problem is that $srcdir (and
# therefore $ac_aux_dir as well) can be either absolute or relative,
# depending on how configure is run.  This is pretty annoying, since
# it makes $ac_aux_dir quite unusable in subdirectories: in the top
# source directory, any form will work fine, but in subdirectories a
# relative path needs to be adjusted first.
#
# $ac_aux_dir/missing
#    fails when called from a subdirectory if $ac_aux_dir is relative
# $top_srcdir/$ac_aux_dir/missing
#    fails if $ac_aux_dir is absolute,
#    fails when called from a subdirectory in a VPATH build with
#          a relative $ac_aux_dir
#
# The reason of the latter failure is that $top_srcdir and $ac_aux_dir
# are both prefixed by $srcdir.  In an in-source build this is usually
# harmless because $srcdir is `.', but things will broke when you
# start a VPATH build or use an absolute $srcdir.
#
# So we could use something similar to $top_srcdir/$ac_aux_dir/missing,
# iff we strip the leading $srcdir from $ac_aux_dir.  That would be:
#   am_aux_dir='\$(top_srcdir)/'`expr "$ac_aux_dir" : "$srcdir//*\(.*\)"`
# and then we would define $MISSING as
#   MISSING="\${SHELL} $am_aux_dir/missing"
# This will work as long as MISSING is not called from configure, because
# unfortunately $(top_srcdir) has no meaning in configure.
# However there are other variables, like CC, which are often used in
# configure, and could therefore not use this "fixed" $ac_aux_dir.
#
# Another solution, used here, is to always expand $ac_aux_dir to an
# absolute PATH.  The drawback is that using absolute paths prevent a
# configured tree to be moved without reconfiguration.

AC_DEFUN([AM_AUX_DIR_EXPAND], [
# expand $ac_aux_dir to an absolute path
am_aux_dir=`CDPATH=:; cd $ac_aux_dir && pwd`
])

# AM_PROG_INSTALL_SH
# ------------------
# Define $install_sh.
AC_DEFUN([AM_PROG_INSTALL_SH],
[AC_REQUIRE([AM_AUX_DIR_EXPAND])dnl
install_sh=${install_sh-"$am_aux_dir/install-sh"}
AC_SUBST(install_sh)])

# One issue with vendor `install' (even GNU) is that you can't
# specify the program used to strip binaries.  This is especially
# annoying in cross-compiling environments, where the build's strip
# is unlikely to handle the host's binaries.
# Fortunately install-sh will honor a STRIPPROG variable, so we
# always use install-sh in `make install-strip', and initialize
# STRIPPROG with the value of the STRIP variable (set by the user).
AC_DEFUN([AM_PROG_INSTALL_STRIP],
[AC_REQUIRE([AM_PROG_INSTALL_SH])dnl
INSTALL_STRIP_PROGRAM="\${SHELL} \$(install_sh) -c -s"
AC_SUBST([INSTALL_STRIP_PROGRAM])])

# serial 4						-*- Autoconf -*-



# There are a few dirty hacks below to avoid letting `AC_PROG_CC' be
# written in clear, in which case automake, when reading aclocal.m4,
# will think it sees a *use*, and therefore will trigger all it's
# C support machinery.  Also note that it means that autoscan, seeing
# CC etc. in the Makefile, will ask for an AC_PROG_CC use...



# _AM_DEPENDENCIES(NAME)
# ---------------------
# See how the compiler implements dependency checking.
# NAME is "CC", "CXX" or "OBJC".
# We try a few techniques and use that to set a single cache variable.
#
# We don't AC_REQUIRE the corresponding AC_PROG_CC since the latter was
# modified to invoke _AM_DEPENDENCIES(CC); we would have a circular
# dependency, and given that the user is not expected to run this macro,
# just rely on AC_PROG_CC.
AC_DEFUN([_AM_DEPENDENCIES],
[AC_REQUIRE([AM_SET_DEPDIR])dnl
AC_REQUIRE([AM_OUTPUT_DEPENDENCY_COMMANDS])dnl
AC_REQUIRE([AM_MAKE_INCLUDE])dnl
AC_REQUIRE([AM_DEP_TRACK])dnl

ifelse([$1], CC,   [depcc="$CC"   am_compiler_list=],
       [$1], CXX,  [depcc="$CXX"  am_compiler_list=],
       [$1], OBJC, [depcc="$OBJC" am_compiler_list='gcc3 gcc']
       [$1], GCJ,  [depcc="$GCJ"  am_compiler_list='gcc3 gcc'],
                   [depcc="$$1"   am_compiler_list=])

AC_CACHE_CHECK([dependency style of $depcc],
               [am_cv_$1_dependencies_compiler_type],
[if test -z "$AMDEP_TRUE" && test -f "$am_depcomp"; then
  # We make a subdir and do the tests there.  Otherwise we can end up
  # making bogus files that we don't know about and never remove.  For
  # instance it was reported that on HP-UX the gcc test will end up
  # making a dummy file named `D' -- because `-MD' means `put the output
  # in D'.
  mkdir conftest.dir
  # Copy depcomp to subdir because otherwise we won't find it if we're
  # using a relative directory.
  cp "$am_depcomp" conftest.dir
  cd conftest.dir

  am_cv_$1_dependencies_compiler_type=none
  if test "$am_compiler_list" = ""; then
     am_compiler_list=`sed -n ['s/^#*\([a-zA-Z0-9]*\))$/\1/p'] < ./depcomp`
  fi
  for depmode in $am_compiler_list; do
    # We need to recreate these files for each test, as the compiler may
    # overwrite some of them when testing with obscure command lines.
    # This happens at least with the AIX C compiler.
    echo '#include "conftest.h"' > conftest.c
    echo 'int i;' > conftest.h
    echo "${am__include} ${am__quote}conftest.Po${am__quote}" > confmf

    case $depmode in
    nosideeffect)
      # after this tag, mechanisms are not by side-effect, so they'll
      # only be used when explicitly requested
      if test "x$enable_dependency_tracking" = xyes; then
	continue
      else
	break
      fi
      ;;
    none) break ;;
    esac
    # We check with `-c' and `-o' for the sake of the "dashmstdout"
    # mode.  It turns out that the SunPro C++ compiler does not properly
    # handle `-M -o', and we need to detect this.
    if depmode=$depmode \
       source=conftest.c object=conftest.o \
       depfile=conftest.Po tmpdepfile=conftest.TPo \
       $SHELL ./depcomp $depcc -c conftest.c -o conftest.o >/dev/null 2>&1 &&
       grep conftest.h conftest.Po > /dev/null 2>&1 &&
       ${MAKE-make} -s -f confmf > /dev/null 2>&1; then
      am_cv_$1_dependencies_compiler_type=$depmode
      break
    fi
  done

  cd ..
  rm -rf conftest.dir
else
  am_cv_$1_dependencies_compiler_type=none
fi
])
$1DEPMODE="depmode=$am_cv_$1_dependencies_compiler_type"
AC_SUBST([$1DEPMODE])
])


# AM_SET_DEPDIR
# -------------
# Choose a directory name for dependency files.
# This macro is AC_REQUIREd in _AM_DEPENDENCIES
AC_DEFUN([AM_SET_DEPDIR],
[rm -f .deps 2>/dev/null
mkdir .deps 2>/dev/null
if test -d .deps; then
  DEPDIR=.deps
else
  # MS-DOS does not allow filenames that begin with a dot.
  DEPDIR=_deps
fi
rmdir .deps 2>/dev/null
AC_SUBST(DEPDIR)
])


# AM_DEP_TRACK
# ------------
AC_DEFUN([AM_DEP_TRACK],
[AC_ARG_ENABLE(dependency-tracking,
[  --disable-dependency-tracking Speeds up one-time builds
  --enable-dependency-tracking  Do not reject slow dependency extractors])
if test "x$enable_dependency_tracking" != xno; then
  am_depcomp="$ac_aux_dir/depcomp"
  AMDEPBACKSLASH='\'
fi
AM_CONDITIONAL([AMDEP], [test "x$enable_dependency_tracking" != xno])
pushdef([subst], defn([AC_SUBST]))
subst(AMDEPBACKSLASH)
popdef([subst])
])

# Generate code to set up dependency tracking.
# This macro should only be invoked once -- use via AC_REQUIRE.
# Usage:
# AM_OUTPUT_DEPENDENCY_COMMANDS

#
# This code is only required when automatic dependency tracking
# is enabled.  FIXME.  This creates each `.P' file that we will
# need in order to bootstrap the dependency handling code.
AC_DEFUN([AM_OUTPUT_DEPENDENCY_COMMANDS],[
AC_OUTPUT_COMMANDS([
test x"$AMDEP_TRUE" != x"" ||
for mf in $CONFIG_FILES; do
  case "$mf" in
  Makefile) dirpart=.;;
  */Makefile) dirpart=`echo "$mf" | sed -e 's|/[^/]*$||'`;;
  *) continue;;
  esac
  grep '^DEP_FILES *= *[^ #]' < "$mf" > /dev/null || continue
  # Extract the definition of DEP_FILES from the Makefile without
  # running `make'.
  DEPDIR=`sed -n -e '/^DEPDIR = / s///p' < "$mf"`
  test -z "$DEPDIR" && continue
  # When using ansi2knr, U may be empty or an underscore; expand it
  U=`sed -n -e '/^U = / s///p' < "$mf"`
  test -d "$dirpart/$DEPDIR" || mkdir "$dirpart/$DEPDIR"
  # We invoke sed twice because it is the simplest approach to
  # changing $(DEPDIR) to its actual value in the expansion.
  for file in `sed -n -e '
    /^DEP_FILES = .*\\\\$/ {
      s/^DEP_FILES = //
      :loop
	s/\\\\$//
	p
	n
	/\\\\$/ b loop
      p
    }
    /^DEP_FILES = / s/^DEP_FILES = //p' < "$mf" | \
       sed -e 's/\$(DEPDIR)/'"$DEPDIR"'/g' -e 's/\$U/'"$U"'/g'`; do
    # Make sure the directory exists.
    test -f "$dirpart/$file" && continue
    fdir=`echo "$file" | sed -e 's|/[^/]*$||'`
    $ac_aux_dir/mkinstalldirs "$dirpart/$fdir" > /dev/null 2>&1
    # echo "creating $dirpart/$file"
    echo '# dummy' > "$dirpart/$file"
  done
done
], [AMDEP_TRUE="$AMDEP_TRUE"
ac_aux_dir="$ac_aux_dir"])])

# AM_MAKE_INCLUDE()
# -----------------
# Check to see how make treats includes.
AC_DEFUN([AM_MAKE_INCLUDE],
[am_make=${MAKE-make}
cat > confinc << 'END'
doit:
	@echo done
END
# If we don't find an include directive, just comment out the code.
AC_MSG_CHECKING([for style of include used by $am_make])
am__include='#'
am__quote=
_am_result=none
# First try GNU make style include.
echo "include confinc" > confmf
# We grep out `Entering directory' and `Leaving directory'
# messages which can occur if `w' ends up in MAKEFLAGS.
# In particular we don't look at `^make:' because GNU make might
# be invoked under some other name (usually "gmake"), in which
# case it prints its new name instead of `make'.
if test "`$am_make -s -f confmf 2> /dev/null | fgrep -v 'ing directory'`" = "done"; then
   am__include=include
   am__quote=
   _am_result=GNU
fi
# Now try BSD make style include.
if test "$am__include" = "#"; then
   echo '.include "confinc"' > confmf
   if test "`$am_make -s -f confmf 2> /dev/null`" = "done"; then
      am__include=.include
      am__quote='"'
      _am_result=BSD
   fi
fi
AC_SUBST(am__include)
AC_SUBST(am__quote)
AC_MSG_RESULT($_am_result)
rm -f confinc confmf
])

# serial 3

# AM_CONDITIONAL(NAME, SHELL-CONDITION)
# -------------------------------------
# Define a conditional.
#
# FIXME: Once using 2.50, use this:
# m4_match([$1], [^TRUE\|FALSE$], [AC_FATAL([$0: invalid condition: $1])])dnl
AC_DEFUN([AM_CONDITIONAL],
[ifelse([$1], [TRUE],
        [errprint(__file__:__line__: [$0: invalid condition: $1
])dnl
m4exit(1)])dnl
ifelse([$1], [FALSE],
       [errprint(__file__:__line__: [$0: invalid condition: $1
])dnl
m4exit(1)])dnl
AC_SUBST([$1_TRUE])
AC_SUBST([$1_FALSE])
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

# serial 3

# When config.status generates a header, we must update the stamp-h file.
# This file resides in the same directory as the config header
# that is generated.  We must strip everything past the first ":",
# and everything past the last "/".

AC_PREREQ([2.12])

AC_DEFUN([AM_CONFIG_HEADER],
[ifdef([AC_FOREACH],dnl
	 [dnl init our file count if it isn't already
	 m4_ifndef([_AM_Config_Header_Index], m4_define([_AM_Config_Header_Index], [0]))
	 dnl prepare to store our destination file list for use in config.status
	 AC_FOREACH([_AM_File], [$1],
		    [m4_pushdef([_AM_Dest], m4_patsubst(_AM_File, [:.*]))
		    m4_define([_AM_Config_Header_Index], m4_incr(_AM_Config_Header_Index))
		    dnl and add it to the list of files AC keeps track of, along
		    dnl with our hook
		    AC_CONFIG_HEADERS(_AM_File,
dnl COMMANDS, [, INIT-CMDS]
[# update the timestamp
echo timestamp >"AS_ESCAPE(_AM_DIRNAME(]_AM_Dest[))/stamp-h]_AM_Config_Header_Index["
][$2]m4_ifval([$3], [, [$3]]))dnl AC_CONFIG_HEADERS
		    m4_popdef([_AM_Dest])])],dnl
[AC_CONFIG_HEADER([$1])
  AC_OUTPUT_COMMANDS(
   ifelse(patsubst([$1], [[^ ]], []),
	  [],
	  [test -z "$CONFIG_HEADERS" || echo timestamp >dnl
	   patsubst([$1], [^\([^:]*/\)?.*], [\1])stamp-h]),dnl
[am_indx=1
for am_file in $1; do
  case " \$CONFIG_HEADERS " in
  *" \$am_file "*)
    am_dir=\`echo \$am_file |sed 's%:.*%%;s%[^/]*\$%%'\`
    if test -n "\$am_dir"; then
      am_tmpdir=\`echo \$am_dir |sed 's%^\(/*\).*\$%\1%'\`
      for am_subdir in \`echo \$am_dir |sed 's%/% %'\`; do
        am_tmpdir=\$am_tmpdir\$am_subdir/
        if test ! -d \$am_tmpdir; then
          mkdir \$am_tmpdir
        fi
      done
    fi
    echo timestamp > "\$am_dir"stamp-h\$am_indx
    ;;
  esac
  am_indx=\`expr \$am_indx + 1\`
done])
])]) # AM_CONFIG_HEADER

# _AM_DIRNAME(PATH)
# -----------------
# Like AS_DIRNAME, only do it during macro expansion
AC_DEFUN([_AM_DIRNAME],
       [m4_if(m4_regexp([$1], [^.*[^/]//*[^/][^/]*/*$]), -1,
	      m4_if(m4_regexp([$1], [^//\([^/]\|$\)]), -1,
		    m4_if(m4_regexp([$1], [^/.*]), -1,
			  [.],
			  m4_patsubst([$1], [^\(/\).*], [\1])),
		    m4_patsubst([$1], [^\(//\)\([^/].*\|$\)], [\1])),
	      m4_patsubst([$1], [^\(.*[^/]\)//*[^/][^/]*/*$], [\1]))[]dnl
]) # _AM_DIRNAME

dnl @synopsis ACX_PTHREAD([ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]])
dnl
dnl This macro figures out how to build C programs using POSIX
dnl threads.  It sets the PTHREAD_LIBS output variable to the threads
dnl library and linker flags, and the PTHREAD_CFLAGS output variable
dnl to any special C compiler flags that are needed.  (The user can also
dnl force certain compiler flags/libs to be tested by setting these
dnl environment variables.)
dnl
dnl Also sets PTHREAD_CC to any special C compiler that is needed for
dnl multi-threaded programs (defaults to the value of CC otherwise).
dnl (This is necessary on AIX to use the special cc_r compiler alias.)
dnl
dnl If you are only building threads programs, you may wish to
dnl use these variables in your default LIBS, CFLAGS, and CC:
dnl
dnl        LIBS="$PTHREAD_LIBS $LIBS"
dnl        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"
dnl        CC="$PTHREAD_CC"
dnl
dnl In addition, if the PTHREAD_CREATE_JOINABLE thread-attribute
dnl constant has a nonstandard name, defines PTHREAD_CREATE_JOINABLE
dnl to that name (e.g. PTHREAD_CREATE_UNDETACHED on AIX).
dnl
dnl ACTION-IF-FOUND is a list of shell commands to run if a threads
dnl library is found, and ACTION-IF-NOT-FOUND is a list of commands
dnl to run it if it is not found.  If ACTION-IF-FOUND is not specified,
dnl the default action will define HAVE_PTHREAD.
dnl
dnl Please let the authors know if this macro fails on any platform,
dnl or if you have any other suggestions or comments.  This macro was
dnl based on work by SGJ on autoconf scripts for FFTW (www.fftw.org)
dnl (with help from M. Frigo), as well as ac_pthread and hb_pthread
dnl macros posted by AFC to the autoconf macro repository.  We are also
dnl grateful for the helpful feedback of numerous users.
dnl
dnl @version $Id: acx_pthread.m4,v 1.4 2005/07/29 22:05:04 ca Exp $
dnl @version $Gnu-Id: acx_pthread.m4,v 1.6 2002/07/13 08:46:20 simons Exp $
dnl @author Steven G. Johnson <stevenj@alum.mit.edu> and Alejandro Forero Cuervo <bachue@bachue.com>

AC_DEFUN([ACX_PTHREAD], [
AC_REQUIRE([AC_CANONICAL_HOST])
AC_LANG_SAVE
AC_LANG_C
acx_pthread_ok=no

# We used to check for pthread.h first, but this fails if pthread.h
# requires special compiler flags (e.g. on True64 or Sequent).
# It gets checked for in the link test anyway.

# First of all, check if the user has set any of the PTHREAD_LIBS,
# etcetera environment variables, and if threads linking works using
# them:
if test x"$PTHREAD_LIBS$PTHREAD_CFLAGS" != x; then
        save_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        AC_MSG_CHECKING([for pthread_join in LIBS=$PTHREAD_LIBS with CFLAGS=$PTHREAD_CFLAGS])
        AC_TRY_LINK_FUNC(pthread_join, acx_pthread_ok=yes)
        AC_MSG_RESULT($acx_pthread_ok)
        if test x"$acx_pthread_ok" = xno; then
                PTHREAD_LIBS=""
                PTHREAD_CFLAGS=""
        fi
        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"
fi

# We must check for the threads library under a number of different
# names; the ordering is very important because some systems
# (e.g. DEC) have both -lpthread and -lpthreads, where one of the
# libraries is broken (non-POSIX).

# Create a list of thread flags to try.  Items starting with a "-" are
# C compiler flags, and other items are library names, except for "none"
# which indicates that we try without any flags at all, and "pthread-config"
# which is a program returning the flags for the Pth emulation library.

acx_pthread_flags="pthreads none -Kthread -kthread lthread -pthread -pthreads -mthreads pthread --thread-safe -mt pthread-config"

# The ordering *is* (sometimes) important.  Some notes on the
# individual items follow:

# pthreads: AIX (must check this before -lpthread)
# none: in case threads are in libc; should be tried before -Kthread and
#       other compiler flags to prevent continual compiler warnings
# -Kthread: Sequent (threads in libc, but -Kthread needed for pthread.h)
# -kthread: FreeBSD kernel threads (preferred to -pthread since SMP-able)
# lthread: LinuxThreads port on FreeBSD (also preferred to -pthread)
# -pthread: Linux/gcc (kernel threads), BSD/gcc (userland threads)
# -pthreads: Solaris/gcc
# -mthreads: Mingw32/gcc, Lynx/gcc
# -mt: Sun Workshop C (may only link SunOS threads [-lthread], but it
#      doesn't hurt to check since this sometimes defines pthreads too;
#      also defines -D_REENTRANT)
# pthread: Linux, etcetera
# --thread-safe: KAI C++
# pthread-config: use pthread-config program (for GNU Pth library)

case "${host_cpu}-${host_os}" in
        *solaris*)

        # On Solaris (at least, for some versions), libc contains stubbed
        # (non-functional) versions of the pthreads routines, so link-based
        # tests will erroneously succeed.  (We need to link with -pthread or
        # -lpthread.)  (The stubs are missing pthread_cleanup_push, or rather
        # a function called by this macro, so we could check for that, but
        # who knows whether they'll stub that too in a future libc.)  So,
        # we'll just look for -pthreads and -lpthread first:

        acx_pthread_flags="-pthreads -pthread pthread -mt $acx_pthread_flags"
        ;;

	*hpux11*)
	# HP UX 11: some compilers support -mt to set all options for
	# multithreaded programs
	acx_pthread_flags="pthreads none -mt -Kthread -kthread lthread -pthread -pthreads -mthreads pthread --thread-safe pthread-config"
	;;
esac

if test x"$acx_pthread_ok" = xno; then
for flag in $acx_pthread_flags; do

        case $flag in
                none)
                AC_MSG_CHECKING([whether pthreads work without any flags])
                ;;

                -*)
                AC_MSG_CHECKING([whether pthreads work with $flag])
                PTHREAD_CFLAGS="$flag"
                ;;

		pthread-config)
		AC_CHECK_PROG(acx_pthread_config, pthread-config, yes, no)
		if test x"$acx_pthread_config" = xno; then continue; fi
		PTHREAD_CFLAGS="`pthread-config --cflags`"
		PTHREAD_LIBS="`pthread-config --ldflags` `pthread-config --libs`"
		;;

                *)
                AC_MSG_CHECKING([for the pthreads library -l$flag])
                PTHREAD_LIBS="-l$flag"
                ;;
        esac

        save_LIBS="$LIBS"
        save_CFLAGS="$CFLAGS"
        LIBS="$PTHREAD_LIBS $LIBS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

        # Check for various functions.  We must include pthread.h,
        # since some functions may be macros.  (On the Sequent, we
        # need a special flag -Kthread to make this header compile.)
        # We check for pthread_join because it is in -lpthread on IRIX
        # while pthread_create is in libc.  We check for pthread_attr_init
        # due to DEC craziness with -lpthreads.  We check for
        # pthread_cleanup_push because it is one of the few pthread
        # functions on Solaris that doesn't have a non-functional libc stub.
        # We try pthread_create on general principles.
        AC_TRY_LINK([#include <pthread.h>],
                    [pthread_t th; th=0;pthread_join(th, 0);
                     pthread_attr_init(0); pthread_cleanup_push(0, 0);
                     pthread_create(0,0,0,0); pthread_cleanup_pop(0); ],
                    [acx_pthread_ok=yes])

        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"

        AC_MSG_RESULT($acx_pthread_ok)
        if test "x$acx_pthread_ok" = xyes; then
                break;
        fi

        PTHREAD_LIBS=""
        PTHREAD_CFLAGS=""
done
fi

# Various other checks:
if test "x$acx_pthread_ok" = xyes; then
        save_LIBS="$LIBS"
        LIBS="$PTHREAD_LIBS $LIBS"
        save_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

        # Detect AIX lossage: threads are created detached by default
        # and the JOINABLE attribute has a nonstandard name (UNDETACHED).
        AC_MSG_CHECKING([for joinable pthread attribute])
        AC_TRY_LINK([#include <pthread.h>],
                    [int attr=PTHREAD_CREATE_JOINABLE;],
                    ok=PTHREAD_CREATE_JOINABLE, ok=unknown)
        if test x"$ok" = xunknown; then
                AC_TRY_LINK([#include <pthread.h>],
                            [int attr=PTHREAD_CREATE_UNDETACHED;],
                            ok=PTHREAD_CREATE_UNDETACHED, ok=unknown)
        fi
        if test x"$ok" != xPTHREAD_CREATE_JOINABLE; then
                AC_DEFINE(PTHREAD_CREATE_JOINABLE, $ok,
                          [Define to the necessary symbol if this constant
                           uses a non-standard name on your system.])
        fi
        AC_MSG_RESULT(${ok})
        if test x"$ok" = xunknown; then
                AC_MSG_WARN([we do not know how to create joinable pthreads])
        fi

        AC_MSG_CHECKING([if more special flags are required for pthreads])
        flag=no
        case "${host_cpu}-${host_os}" in
                *-aix* | *-freebsd* | *-darwin*) flag="-D_THREAD_SAFE";;
                *solaris* | *-osf* | *-hpux*) flag="-D_REENTRANT";;
        esac
        AC_MSG_RESULT(${flag})
        if test "x$flag" != xno; then
                PTHREAD_CFLAGS="$flag $PTHREAD_CFLAGS"
        fi

        LIBS="$save_LIBS"
        CFLAGS="$save_CFLAGS"

        # More AIX lossage: must compile with cc_r
        AC_CHECK_PROG(PTHREAD_CC, cc_r, cc_r, ${CC})
else
        PTHREAD_CC="$CC"
fi

AC_SUBST(PTHREAD_LIBS)
AC_SUBST(PTHREAD_CFLAGS)
AC_SUBST(PTHREAD_CC)

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_pthread_ok" = xyes; then
        ifelse([$1],,AC_DEFINE(HAVE_PTHREAD,1,[Define if you have POSIX threads libraries and header files.]),[$1])
        :
else
        acx_pthread_ok=no
        $2
fi
AC_LANG_RESTORE
])dnl ACX_PTHREAD

dnl $Id: acsite.m4,v 1.56 2005/10/26 19:00:08 ca Exp $

dnl ##########################################################################
dnl ###  SM_UNSIGNED_SIZE_T - check for unsigned size_t
dnl ##########################################################################

AC_DEFUN([SM_UNSIGNED_SIZE_T], [
  AC_CACHE_CHECK([for unsigned size_t],
    sm_cv_unsigned_size_t,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sys/types.h>

int main()
{
	size_t v;

	v = 0;
	--v;
	if (v > 0)
		exit(0);
	exit(1);
}
>>changequote([, ]),
      sm_cv_unsigned_size_t=yes,
      sm_cv_unsigned_size_t=no,
      sm_cv_unsigned_size_t=no
    )]
  )
  if test "$sm_cv_unsigned_size_t" = "yes"; then
    AC_DEFINE(HAVE_UNSIGNED_SIZE_T, 1, [Define if your system size_t is unsigned ])
  fi
])

dnl ##########################################################################
dnl ###  SM_UNSIGNED_CHAR - check for unsigned char
dnl ##########################################################################

AC_DEFUN([SM_UNSIGNED_CHAR], [
  AC_CACHE_CHECK([for unsigned char],
    sm_cv_unsigned_char,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sys/types.h>

int main()
{
	char v;

	v = 0;
	--v;
	if (v > 0)
		exit(0);
	exit(1);
}
>>changequote([, ]),
      sm_cv_unsigned_char=yes,
      sm_cv_unsigned_char=no,
      sm_cv_unsigned_char=no
    )]
  )
  if test "$sm_cv_unsigned_char" = "yes"; then
    AC_DEFINE(HAVE_UNSIGNED_CHAR, 1, [Define if your system char is unsigned ])
  fi
])

dnl ##########################################################################
dnl ###  SM_STATFS_4ARGS - check for four-argument statfs call
dnl ##########################################################################

AC_DEFUN([SM_STATFS_4ARGS], [
  AC_CACHE_CHECK([for four-argument statfs call],
    sm_cv_statfs_4args,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#if HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#endif
#if HAVE_SYS_MOUNT_H
#include <sys/param.h>
#include <sys/mount.h>
#endif

int main()
{
	char *dir;
	struct statfs fs;

	dir = ".";
	if (statfs(dir, &fs, sizeof fs, 0) == 0)
		exit(0);
	exit(1);
}
>>changequote([, ]),
      sm_cv_statfs_4args=yes,
      sm_cv_statfs_4args=no,
      sm_cv_statfs_4args=no
    )]
  )
  if test "$sm_cv_statfs_4args" = "yes"; then
    AC_DEFINE(HAVE_STATFS_4ARGS, 1, [Define if statfs uses four arguments])
  fi
])

dnl ##########################################################################
dnl ###  SM_FUNC_SNPRINTF - check for working snprintf()
dnl ##########################################################################

AC_DEFUN([SM_FUNC_SNPRINTF], [
  AC_CACHE_CHECK([for working snprintf],
    sm_cv_func_snprintf_works,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>

typedef struct {
  int length;
  char *test;
  int retval;
  char *result;
} test_t;

const test_t tests[] = {
  { 10, "12345678901234567890", 20, "123456789" },
#if 0
  { 0, "12345678901234567890", 20, NULL },
  { -1, "12345678901234567890", -1, NULL },
#endif
  { 0, NULL, 0, NULL }
};

int main() {
  char test1[1024];
  int i;

  for (i = 0; tests[i].test; i++) {
    memset(test1, 'X', sizeof(test1));
    if ((snprintf(test1, tests[i].length, "%s", tests[i].test)
         != tests[i].retval) ||
        (tests[i].result && strcmp(tests[i].result, test1)))
      exit(1);
  }

  exit(0);
}
>>changequote([, ]),
      sm_cv_func_snprintf_works=yes,
      sm_cv_func_snprintf_works=no,
      sm_cv_func_snprintf_works=no
    )]
  )
  if test "$sm_cv_func_snprintf_works" = "yes"; then
    AC_DEFINE(HAVE_SNPRINTF, 1, [Define if your system has a working snprintf])
  else
    LIBOBJS="$LIBOBJS snprintf.o"
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE - check for arbitrary type in arbitrary header file(s)
dnl ##########################################################################

dnl ### Usage: SM_TYPE(type_t, default, [ #include <hdr1.h> ... ])
AC_DEFUN([SM_TYPE], [
  AC_CACHE_CHECK(if $1 is defined, sm_cv_type_$1,
    AC_TRY_LINK($3,
      $1 x;,
      sm_cv_type_$1=yes,
      sm_cv_type_$1=no
    )
  )
  if test "$sm_cv_type_$1" != "yes"; then
    AC_DEFINE($1, $2, Define if your system does not have $1)
  fi
])

dnl ##########################################################################
dnl ###  SM_LIB_WRAP - check for TCP Wrappers library
dnl ##########################################################################

AC_DEFUN([SM_LIB_WRAP], [
  AC_CHECK_HEADERS(tcpd.h)
  if test "$ac_cv_header_tcpd_h" = "yes"; then
    sm_old_libs="$LIBS"
    LIBS="$LIBS -lwrap"
    AC_CACHE_CHECK([for libwrap library], sm_cv_lib_wrap_hosts_ctl,
      AC_TRY_LINK(
        [
          #include <stdio.h>
          #include <tcpd.h>
          int allow_severity;
          int deny_severity;
        ], [
          hosts_ctl("test", STRING_UNKNOWN, "10.0.0.1", STRING_UNKNOWN);
        ],
        sm_cv_lib_wrap_hosts_ctl=yes,
        sm_cv_lib_wrap_hosts_ctl=no
      )
    )
    if test "$sm_cv_lib_wrap_hosts_ctl" = "yes"; then
      AC_DEFINE(HAVE_LIBWRAP, 1, [Define if you have libwrap])
    else
      LIBS="$sm_old_libs"
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_CHECK_RES_SEARCH - check for broken res_search()
dnl ##########################################################################

AC_DEFUN([SM_CHECK_RES_SEARCH], [
  AC_CACHE_CHECK([for broken res_search],
    sm_cv_func_broken_res_search,
    AC_TRY_RUN(
      [
	#include <sys/types.h>
	#include <netinet/in.h>
	#include <arpa/nameser.h>
	#include <resolv.h>

	int main()
	{
	  unsigned char answer[1024];

	  if (res_search("unknown.sendmail.org", C_IN, T_MX,
		         answer, sizeof(answer)) == -1
	      && h_errno == 0)
	    exit(0);

	  exit(1);
	}
      ],
      sm_cv_func_broken_res_search=yes,
      sm_cv_func_broken_res_search=no
    )
  )
  if test "$sm_cv_func_broken_res_search" = "yes"; then
    AC_DEFINE(BROKEN_RES_SEARCH, 1,
              [Define if res_search sets h_errno to 0 on unknown hosts])
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_ACCEPT - check for type of 3rd arg to accept()
dnl ##########################################################################

AC_DEFUN([SM_TYPE_ACCEPT], [
  AC_CHECK_FUNCS(accept)
  if test "$ac_cv_func_accept" = "yes"; then
    AC_CACHE_CHECK([for type of argument 3 of accept],
      sm_cv_type_accept_arg3,
      for sm_type in 'socklen_t' 'size_t' 'unsigned long'  'unsigned int' 'int'; do
	AC_TRY_COMPILE(
	  [
	    #include <sys/types.h>
	    #include <sys/socket.h>
	  ], [
	    extern int accept(int, struct sockaddr *, $sm_type *);
          ],
          [ sm_cv_type_accept_arg3=$sm_type; break ]
        )
      done
      if test "$sm_cv_type_accept_arg3" = ""; then
	sm_cv_type_accept_arg3="int";
      fi
    )
    if test "$sm_cv_type_accept_arg3" != ""; then
      AC_DEFINE_UNQUOTED(socklen_T, $sm_cv_type_accept_arg3,
                         [Define to the type of the 3rd arg to accept()])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_GETSOCKOPT - check for type of 5th arg to getsockopt()
dnl ##########################################################################

AC_DEFUN([SM_TYPE_GETSOCKOPT], [
  AC_CHECK_FUNCS(getsockopt)
  if test "$ac_cv_func_getsockopt" = "yes"; then
    AC_CACHE_CHECK([for type of argument 5 of getsockopt],
      sm_cv_type_getsockopt_arg5,
      for sm_type in 'socklen_t' 'size_t' 'int'; do
	AC_TRY_COMPILE(
	  [
	    #include <sys/types.h>
	    #include <sys/socket.h>
	  ], [
	    extern int getsockopt(int, int, int, void *, $sm_type *);
          ],
          [ sm_cv_type_getsockopt_arg5=$sm_type; break ]
        )
      done
      if test "$sm_cv_type_getsockopt_arg5" = ""; then
	sm_cv_type_getsockopt_arg5="int";
      fi
    )
    if test "$sm_cv_type_getsockopt_arg5" != ""; then
      AC_DEFINE_UNQUOTED(sockoptlen_T, $sm_cv_type_getsockopt_arg5,
                         [Define to the type of the 5th arg to getsockopt()])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_GETPWNAME_R - check for POSIX conformance of getpwnam_r()
dnl ##########################################################################

AC_DEFUN([SM_TYPE_GETPWNAME_R], [
  AC_CHECK_FUNCS(getpwnam_r)
    AC_CACHE_CHECK([for POSIX conformance of getpwnam_r],
      sm_cv_posix_getpwnam_r,
	[AC_TRY_LINK(
changequote(<<, >>)<<
#ifndef _POSIX_PTHREAD_SEMANTICS
#define _POSIX_PTHREAD_SEMANTICS 1
#endif
#include <pwd.h>
int r;
struct passwd *pwent;
struct passwd pwentb;
char buf[1024];
	  >>,
	  <<
	    r = getpwnam_r("root", &pwentb, buf, sizeof(buf), &pwent);
>>changequote([, ]),
      sm_cv_posix_getpwnam_r=yes,
      sm_cv_posix_getpwnam_r=no
        )]
    )
  if test "$sm_cv_posix_getpwnam_r" = "yes"; then
	AC_DEFINE_UNQUOTED(POSIX_GETPWNAM_R, 1, [Define if getpwnam_r() conforms to POSIX])
  fi
])


dnl ##########################################################################
dnl ###  SM_SIGWAIT - check for interface to sigwait()
dnl ##########################################################################

AC_DEFUN([SM_SIGWAIT], [
  AC_CHECK_FUNCS(sigwait)
  if test "$ac_cv_func_sigwait" = "yes"; then
    AC_CACHE_CHECK([whether sigwait takes only one argument],
      sm_cv_func_sigwait_one_arg,
      AC_TRY_COMPILE(
	[
	  #include <signal.h>
	], [
	  extern int sigwait(sigset_t *);
	],
	sm_cv_func_sigwait_one_arg=yes,
	sm_cv_func_sigwait_one_arg=no
      )
    )
    if test "$sm_cv_func_sigwait_one_arg" = "yes"; then
      AC_DEFINE(SIGWAIT_ONE_ARG, 1, [Define if sigwait() takes only one arg])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_TYPE_CTIME_R - check ctime_r() parameters:
dnl ###  char *ctime_r(const time_t *clock, char *buf);
dnl ###  char *ctime_r(const time_t *clock, char *buf, int buflen);
dnl ##########################################################################

AC_DEFUN([SM_TYPE_CTIME_R], [
  AC_CHECK_FUNCS(ctime_r)
  if test "$ac_cv_func_ctime_r" = "yes"; then
    AC_CACHE_CHECK([ctime_r API], sm_cv_type_ctime_r,
	AC_TRY_COMPILE(
	  [
	    #include <sys/types.h>
	    #include <sys/socket.h>
	  ], [
	    extern char *ctime_r(const time_t *_clock, char *_buf);
	  ],
	  [ sm_cv_type_ctime_r=2 ],
	    AC_TRY_COMPILE(
	      [
	        #include <sys/types.h>
	        #include <sys/socket.h>
	      ], [
	        extern char *ctime_r(const time_t *_clock, char *_buf, int _buflen);
	      ],
	      [ sm_cv_type_ctime_r=3 ],
	   )
	)
      if test "$sm_cv_type_ctime_r" = ""; then
	sm_cv_type_ctime_r=0;
      fi
    )
    if test "$sm_cv_type_ctime_r" != ""; then
      AC_DEFINE_UNQUOTED(SM_CTIME_R_API, $sm_cv_type_ctime_r,
			 [Specify API of ctime_r()])
    fi
  fi
])

dnl ##########################################################################
dnl ###  SM_SAFE_CTYPE ctype.h misbehaves with non-ASCII characters.
dnl ##########################################################################

AC_DEFUN([SM_SAFE_CTYPE], [
  AC_CACHE_CHECK([for safe ctype],
    sm_cv_safe_ctype,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <ctype.h>

int main()
{
	int v;
	char upper[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+-=|~,./;'[]<>?:{}  ";
	char lower[] = "abcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=|~,./;'[]<>?:{}  ";

	v = EOF;
	if (isalnum(v))
		exit(1);
	if (isprint(v))
		exit(1);
	upper[sizeof(upper) - 2] = '\"';
	lower[sizeof(lower) - 2] = '\"';
	for (v = 128; v < 256; v++)
		if (isalnum(v))
			exit(1);
	for (v = 0; v < sizeof(upper); v++)
	{
		if (tolower(upper[v]) != lower[v])
			exit(1);
		if (toupper(lower[v]) != upper[v])
			exit(1);
	}
	exit(0);
}
>>changequote([, ]),
      sm_cv_safe_ctype=yes,
      sm_cv_safe_ctype=no,
      sm_cv_safe_ctype=no
    )]
  )
  if test "$sm_cv_safe_ctype" = "yes"; then
    AC_DEFINE(HAVE_SAFE_CTYPE, 1, [Define if your system ctype is 8 bit safe ])
  fi
])

dnl ### Check if msghdr{} has msg_control member.
AC_DEFUN([SM_MSGHDR_MSG_CONTROL], [
AC_CACHE_CHECK(if msghdr{} has msg_control member, ac_cv_msghdr_has_msg_control,
	AC_TRY_COMPILE([
#		include <sys/types.h>
#		include <sys/socket.h>],
		[unsigned int i = sizeof(((struct msghdr *)0)->msg_control)],
	ac_cv_msghdr_has_msg_control=yes,
	ac_cv_msghdr_has_msg_control=no))
if test $ac_cv_msghdr_has_msg_control = yes ; then
	AC_DEFINE(HAVE_MSGHDR_MSG_CONTROL, 1, [Define if msghdr{} has msg_control member])
fi
])

dnl ### Check if sockaddr_un has sun_len member.
AC_DEFUN([SM_SOCK_UN_SUN_LEN], [
AC_CACHE_CHECK(if sockaddr_un has sun_len member, ac_cv_sock_un_sun_len,
	AC_TRY_COMPILE([
#		include <sys/types.h>
#		include <sys/socket.h>
#		include <sys/un.h>],
		[unsigned int i = sizeof(((struct sockaddr_un *)0)->sun_len)],
	ac_cv_sock_un_sun_len=yes,
	ac_cv_sock_un_sun_len=no))
if test $ac_cv_sock_un_sun_len = yes ; then
	AC_DEFINE(HAVE_SOCK_UN_SUN_LEN, 1, [Define if sockaddr_un has sun_len member])
fi
])

dnl ### Check if rusage{} has XYZ member.
AC_DEFUN([SM_RUSAGE_MEMBER], [
AC_CACHE_CHECK(if rusage{} has $1 member, ac_cv_rusage_has_$1,
	AC_TRY_COMPILE([
#		include <sys/time.h>
#		include <sys/resource.h>],
		[unsigned int i = sizeof(((struct rusage *)0)->$1)],
	ac_cv_rusage_has_$1=yes,
	ac_cv_rusage_has_$1=no))
if test $ac_cv_rusage_has_$1 = yes ; then
	AC_DEFINE(SM_RUSAGE_$1, 1, [Define if rusage{} has $1 member])
fi
])

dnl ### Check if stat{} has XYZ member.
AC_DEFUN([SM_STAT_MEMBER], [
AC_CACHE_CHECK(if stat{} has $1 member, ac_cv_stat_has_$1,
	AC_TRY_COMPILE([
#		include <sys/types.h>
#		include <sys/stat.h>],
		[unsigned int i = sizeof(((struct stat *)0)->$1)],
	ac_cv_stat_has_$1=yes,
	ac_cv_stat_has_$1=no))
if test $ac_cv_stat_has_$1 = yes ; then
	AC_DEFINE(SM_STAT_$1, 1, [Define if stat{} has $1 member])
fi
])



dnl ##########################################################################
dnl ###  SM_INET_BLKSIZE stat(inet-sock) returns useful value for blksize
dnl ##########################################################################

AC_DEFUN([SM_INET_BLKSIZE], [
  AC_CACHE_CHECK([stat(inet-sock) returns useful value for blksize],
    sm_cv_stblksz_inet,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>

int
main(int argc, char **argv)
{
	int fd, r, sockt;
	struct stat st;

	sockt = PF_INET;
	if (argc > 1)
	{
		if (strcasecmp(argv[1], "unix") == 0)
			sockt = PF_UNIX;
		else if (strcasecmp(argv[1], "inet") == 0)
			sockt = PF_INET;
		else return -1;
	}
	fd = socket(sockt, SOCK_STREAM, 0);
	if (fd == -1)
		return -1;
	r = fstat(fd, &st);
	if (r == -1)
		return -1;
	if (st.st_blksize < 256)
		return 1;
	return 0;
}
>>changequote([, ]),
      sm_cv_stblksz_inet=yes,
      sm_cv_stblksz_inet=no,
      sm_cv_stblksz_inet=no
    )]
  )
  if test "$sm_cv_stblksz_inet" = "yes"; then
    AC_DEFINE(HAVE_STBLKSZ_INET, 1, [Define if your system returns useful blksize for inet sockets])
  fi
])


dnl ##########################################################################
dnl ###  SM_FREE_NULL - check whether free(NULL) is ok
dnl ##########################################################################

AC_DEFUN([SM_FREE_NULL], [
  AC_CACHE_CHECK([for free(NULL)],
    sm_cv_free_null,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <stdlib.h>

int main()
{
	free(0);
	exit(0);
}
>>changequote([, ]),
      sm_cv_free_null=yes,
      sm_cv_free_null=no,
      sm_cv_free_null=no
    )]
  )
  if test "$sm_cv_free_null" = "yes"; then
    AC_DEFINE(HAVE_FREE_NULL, 1, [Define if your system allows free(NULL)])
  fi
])

dnl ##########################################################################
dnl ###  SM_STRFTIME_E - check whether strftime() supports %e
dnl ##########################################################################

AC_DEFUN([SM_STRFTIME_E], [
  AC_CACHE_CHECK([strftime() supports %e],
    sm_cv_strftime_e,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <sys/types.h>
#include <time.h>

int main(int argc, char **argv)
{
	size_t r;
	time_t t;
	struct tm *ttm;
	char buf[64];

	t = (time_t) 10000;
	ttm = localtime(&t);
	buf[0] = '\0';
	r = strftime(buf, sizeof(buf), "%e", ttm);
	return strcmp(" 1", buf) == 0;
}
>>changequote([, ]),
      sm_cv_strftime_e=yes,
      sm_cv_strftime_e=no,
      sm_cv_strftime_e=no
    )]
  )
  if test "$sm_cv_strftime_e" = "yes"; then
    AC_DEFINE(HAVE_STRFTIME_E, 1, [Define if strftime() supports %e])
  fi
])


dnl ##########################################################################
dnl ###  Berkeley DB 4.x (x > 0)
dnl ##########################################################################

define(BERKELEY_DB4x_FUNC,
changequote(<<, >>)<<
#include <stdio.h>
#include <db.h>

#if DB_VERSION_MAJOR != 4 || (DB_VERSION_MINOR != 1 && DB_VERSION_MINOR != 2 && DB_VERSION_MINOR != 3)
# error  wrong DB version, need 4.1, 4.2, or 4.3
#endif /* DB_VERSION_MAJOR != 4 */

int
main(int argc, char **argv)
{
	DB *db;
	int ret;

	ret = db_create(&db, 0, 0);
	return 0;
}
>>changequote([, ]))

define(BERKELEY_DB4x_FULL,
changequote(<<, >>)<<
#include <stdio.h>
#include <db.h>
#define BDB_NAME "bdb"
int
bdb_open(void)
{
	int r;
	unsigned int flags;
	int major_v, minor_v, patch_v;
	char *dbfile, *dbh;
	DB *dbp;
	DB_ENV *dbenv;
	DB_TXN *db_txn;

	dbp = NULL;
	dbenv = NULL;
	db_txn = NULL;
	dbfile = NULL;
	(void) db_version(&major_v, &minor_v, &patch_v);
	if (major_v != DB_VERSION_MAJOR || minor_v != DB_VERSION_MINOR)
		return -1;
	r = db_env_create(&dbenv, 0);
	if (r != 0)
	{
		dbenv->err(dbenv, r, "db_env_create");
		goto error;
	}
	flags = DB_CREATE | DB_INIT_MPOOL | DB_INIT_TXN |
			DB_INIT_LOCK | DB_PRIVATE | DB_RECOVER;
	dbh = BDB_NAME;
	r  = dbenv->open(dbenv, dbh, flags, 0600);
	if (r != 0)
	{
		dbenv->err(dbenv, r,
			"where=DB_ENV->open, dbhome=%s", dbh);
		goto error;
	}

	/* Create and initialize database object, open the database. */
	r = db_create(&dbp, dbenv, 0);
	if (r != 0)
		goto error;

	db_txn = NULL;
	r = dbenv->txn_begin(dbenv, NULL, &db_txn, 0);
	if (r != 0)
		goto error;

	dbfile = BDB_NAME;

	flags = DB_CREATE;
	r = dbp->open(dbp, db_txn, dbfile, NULL, DB_BTREE, flags, 0600);
	if (r != 0)
	{
		dbp->err(dbp, r, "where=db->open, db=%s", BDB_NAME);
		if (db_txn != NULL)
		{
			(void) db_txn->abort(db_txn);
			db_txn = NULL;
		}
		goto error;
	}

	if (db_txn != NULL)
	{
		r = db_txn->commit(db_txn, 0);
		db_txn = NULL;
		if (r != 0)
			goto error;
	}

	return 0;

  error:
	if (dbp != NULL)
		(void) dbp->close(dbp, 0);
	if (dbenv != NULL)
		(void) dbenv->close(dbenv, 0);
	return r;
}

int
main(int argc, char **argv)
{
	int r;

	(void) unlink(BDB_NAME "/bdb");
	(void) unlink(BDB_NAME "/log.0000000001");
	(void) unlink(BDB_NAME);
	(void) rmdir(BDB_NAME);
	(void) mkdir(BDB_NAME, 0775);
	r = bdb_open();
	(void) unlink(BDB_NAME "/bdb");
	(void) unlink(BDB_NAME "/log.0000000001");
	(void) rmdir(BDB_NAME);
	return r;
}
>>changequote([, ]))

AC_DEFUN([BERKELEY_DB4x_CHK_LIB],
[
	dnl if lib is specified: try static (lib.a)
	bdb_wo_fdatasync="unknown"
	if test -d "$with_bdb_lib"; then
	    BDB_LIBADD="$with_bdb_lib"
	    for dbname in db-4.3 db4.3 db43 db4-4.3 db-4.2 db4.2 db42 db4-4.2 db-4.1 db4.1 db41 db
	    do
	        BDB2_SAVE_LIBS=$LIBS
	        LIBS="$LIBS $BDB_LIBADD/lib${dbname}.a"
		AC_TRY_RUN(BERKELEY_DB4x_FUNC,
			SMX_DB_LIB="$BDB_LIBADD/lib${dbname}.a";
			dblib="berkeley"; break, dblib="no")

	        if test $dblib = "no" -a $fdatasync_in_lrt; then
	          BDB3_SAVE_LIBS=$LIBS
	          LIBS="$LIBS $SMX_FDATASYNC_LIB"
	          AC_TRY_RUN([BERKELEY_DB4x_FUNC],
			SMX_DB_LIB="$BDB_LIBADD/lib${dbname}.a $SMX_FDATASYNC_LIB";
			dblib="berkeley"; break, dblib="no")
	          LIBS=$BDB3_SAVE_LIBS
	        fi

	        LIBS=$BDB2_SAVE_LIBS
	    done
	else
	    for dbname in db-4.3 db4.3 db43 db4-4.3 db-4.2 db4.2 db42 db4-4.2 db-4.1 db4.1 db41 db
	    do
	        BDB2_SAVE_LDFLAGS=$LDFLAGS
	        LDFLAGS="$LDFLAGS -l${dbname}"
		AC_TRY_RUN(BERKELEY_DB4x_FUNC,
			SMX_DB_LIB="-l${dbname}";
			dblib="berkeley"; break, dblib="no")

	        if test $dblib = "no" -a $fdatasync_in_lrt; then
	          BDB3_SAVE_LDFLAGS=$LDFLAGS
	          LDFLAGS="$LDFLAGS $SMX_FDATASYNC_LIB"
	          AC_TRY_RUN([BERKELEY_DB4x_FUNC],
			SMX_DB_LIB="-l${dbname} $SMX_FDATASYNC_LIB";
			dblib="berkeley"; break, dblib="no")
	          LDFLAGS=$BDB3_SAVE_LDFLAGS
	        fi

	        LDFLAGS=$BDB2_SAVE_LDFLAGS
	    done
	fi

	if test $dblib != "no" -a $fdatasync_in_lrt; then
	  BDB3_SAVE_LDFLAGS=$LDFLAGS
	  LDFLAGS="$LDFLAGS $SMX_DB_LIB"
	  AC_TRY_RUN([BERKELEY_DB4x_FULL],
		bdb_wo_fdatasync="ok", bdb_wo_fdatasync="no")
	  LDFLAGS=$BDB3_SAVE_LDFLAGS
	  if test $bdb_wo_fdatasync = "no"; then
	    BDB3_SAVE_LDFLAGS=$LDFLAGS
	    LDFLAGS="$LDFLAGS $SMX_DB_LIB $SMX_FDATASYNC_LIB"
	    AC_TRY_RUN([BERKELEY_DB4x_FULL],
		SMX_DB_LIB="$SMX_DB_LIBS $SMX_FDATASYNC_LIB";
		dblib="berkeley"; break, dblib="no")
	    LDFLAGS=$BDB3_SAVE_LDFLAGS
	  fi
	fi
])

AC_DEFUN([BERKELEY_DB4x_CHK],
[
	if test -d "$with_bdb_inc"; then
	    CPPFLAGS="$CPPFLAGS -I$with_bdb_inc"
	    BDB_INCADD="-I$with_bdb_inc"
	else
	    BDB_INCADD=""
	fi

	AC_CHECK_HEADER(db.h,
                       	BERKELEY_DB4x_CHK_LIB()
			SMX_DB_INC=$BDB_INCADD,
                        dblib="no")
])

AC_DEFUN([SM_BERKELEYDB4], [
  AC_CACHE_CHECK([for Berkeley DB 4.x],
    sm_cv_berkeleyDB4,
    [
	BDB_SAVE_LIBS=$LIBS
	BDB_SAVE_LDFLAGS=$LDFLAGS
	LIBS="$LIBS $SMX_DB_LIB"
	if test -d "$with_bdb_lib"; then
	    LDFLAGS="$LDFLAGS -L$with_bdb_lib"
	fi
AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <db.h>

/*
**  If you change this, change also include/sm/bdb.h
*/
#if DB_VERSION_MAJOR != 4 || (DB_VERSION_MINOR != 1 && DB_VERSION_MINOR != 2 && DB_VERSION_MINOR != 3)
# error  wrong DB version, need 4.x (x > 0)
#endif
#define DB_CACHE_SIZE	1024

int
main(int argc, char **argv)
{
	char *name;
	DBTYPE dbtype;
	DB *db;
	int flags, ret;

	db = NULL;
	flags = DB_CREATE;
	dbtype = DB_HASH;
	ret = db_create(&db, NULL, 0);
	name = "dbtest.db";
	if (ret == 0 && db != NULL)
	{
		ret = db->set_cachesize(db, 0, DB_CACHE_SIZE, 0);
		if (ret != 0)
		{
			(void) db->close(db, 0);
			exit(1);
		}
	}
	if (ret == 0 && db != NULL)
	{
		ret = db->open(db, NULL, name, NULL, dbtype, flags, 0640);
		if (ret != 0)
		{
			(void) db->close(db, 0);
			exit(1);
		}
		(void) db->close(db, 0);
	}
	unlink(name);
	exit(0);
}
>>changequote([, ]),
      sm_cv_berkeleyDB4=yes,
      sm_cv_berkeleyDB4=no,
      sm_cv_berkeleyDB4=no
    )]
	LIBS=$BDB_SAVE_LIBS
	LDFLAGS=$BDB_SAVE_LDFLAGS
  )
  if test "$sm_cv_berkeleyDB4" = "yes"; then
    AC_DEFINE(HAVE_BERKELEYDB4, 1, [Define if Berkeley DB 4.x (x > 0) is available])
  fi
])


dnl ##########################################################################
dnl ###  SYS_NERR
dnl ##########################################################################

AC_DEFUN([SM_SYS_NERR], [
  AC_CACHE_CHECK([for sys_nerr],
    sm_cv_sys_nerr,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
	return (sys_nerr > 0) ? 0 : 1;
}
>>changequote([, ]),
      sm_cv_sys_nerr=yes,
      sm_cv_sys_nerr=no,
      sm_cv_sys_nerr=no
    )]
  )
  if test "$sm_cv_sys_nerr" = "yes"; then
    AC_DEFINE(HAVE_SYS_NERR, 1, [Define if sys_nerr is available])
  fi
])

dnl ##########################################################################
dnl ###  SYS_ERRLIST
dnl ##########################################################################

AC_DEFUN([SM_SYS_ERRLIST], [
  AC_CACHE_CHECK([for sys_errlist],
    sm_cv_sys_errlist,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
	/* hopefully errno==1 is defined */
	return (sys_errlist[1]) ? 0 : 1;
}
>>changequote([, ]),
      sm_cv_sys_errlist=yes,
      sm_cv_sys_errlist=no,
      sm_cv_sys_errlist=no
    )]
  )
  if test "$sm_cv_sys_errlist" = "yes"; then
    AC_DEFINE(HAVE_SYS_ERRLIST, 1, [Define if sys_errlist is available])
  fi
])


dnl ##########################################################################
dnl ###  PTHREAD_RWLOCK_INIT
dnl ##########################################################################

AC_DEFUN([SM_PTHREAD_RWLOCK_INIT], [
  AC_CACHE_CHECK([for pthread_rwlock_init],
    sm_cv_pthread_rwlock_init,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <pthread.h>

int
main(int argc, char **argv)
{
	pthread_rwlock_t rwl;

	if (pthread_rwlock_init(&rwl, 0) != 0)
		exit(1);
	pthread_rwlock_destroy(&rwl);
	exit(0);
}
>>changequote([, ]),
      sm_cv_pthread_rwlock_init=yes,
      sm_cv_pthread_rwlock_init=no,
      sm_cv_pthread_rwlock_init=no
    )]
  )
  if test "$sm_cv_pthread_rwlock_init" = "yes"; then
    AC_DEFINE(HAVE_PTHREAD_RWLOCK_INIT, 1, [Define if pthread_rwlock_init is available])
  fi
])

dnl ##########################################################################
dnl ###  SM_TLS
dnl ##########################################################################

AC_DEFUN([SM_TLS], [
 AC_ARG_ENABLE(TLS, [  --enable-TLS           enable STARTTLS (check libraries) ],
  smtls=$enableval,
  smtls=yes)
  AC_MSG_CHECKING(TLS support)
  SMX_TLS_LIB=""
  if test "$smtls" != no; then
    AC_CHECK_LIB(crypto, BIO_write,
	SMX_TLS_LIB="$SMX_TLS_LIB -lcrypto"; lcrypto="yes", lcrypto="no")
    TLS_SAVE_LIBS=$LIBS
    LIBS="$LIBS $SMX_TLS_LIB"
    AC_CHECK_LIB(ssl, SSL_CTX_new,
	SMX_TLS_LIB="-lssl $SMX_TLS_LIB"; lssl="yes", lssl="no")
    if test "$lcrypto" != no -a "lssl" != no; then
      AC_CACHE_CHECK([for OpenSSL availability],
        sm_cv_openssl,
        [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <openssl/ssl.h>

int main(int argc, char **argv)
{
	unsigned int linkversion;

	linkversion = (unsigned int) SSLeay();
	fprintf(stderr,
		"OpenSSL versions:\n"
		"compiled against: version=0x%08x\n"
		"linked against:   version=0x%08x\n"
		, (unsigned int) OPENSSL_VERSION_NUMBER, linkversion);
	exit(((unsigned int) OPENSSL_VERSION_NUMBER == linkversion)
		? 0 : 1);
}
>>changequote([, ]),
        sm_cv_openssl=yes,
        sm_cv_openssl=no,
        sm_cv_openssl=no
        )]
      )
      if test "$sm_cv_openssl" != no; then
        AC_DEFINE(SM_USE_TLS, 1, [Define if TLS is available and should be used])
        AC_MSG_RESULT(enabled)
      else
        AC_MSG_RESULT(disabled due to failure in test compilation)
      fi
    else
      AC_MSG_RESULT(disabled due to missing libraries)
    fi
    LIBS=$TLS_SAVE_LIBS
  else
    AC_MSG_RESULT(disabled)
  fi
  AC_SUBST(SMX_TLS_LIB)
])

dnl ##########################################################################
dnl ###  SM_SASL
dnl ##########################################################################

AC_DEFUN([SM_SASL], [
 AC_ARG_ENABLE(SASL, [  --enable-SASL          enable SASL (check libraries) ],
  smsasl=$enableval,
  smsasl=yes)
  AC_MSG_CHECKING(SASL support)
  SMX_SASL_LIB=""
  SMX_SASL_INC=""
  if test "$smsasl" = yes; then
    SASL_SAVE_LDFLAGS=$LDFLAGS
    SASL_SAVE_CFLAGS=$CFLAGS
    SASL_SAVE_CPPFLAGS=$CPPFLAGS
    SASL_SAVE_LIBS=$LIBS
    SASL_ADD_L=""
    if test -d "$with_sasl_lib"; then
      SASL_ADD_L="-L$with_sasl_lib"
      LDFLAGS="$LDFLAGS $SASL_ADD_L"
    fi
    SM_SASL_LIB="-lsasl2"
    AC_CHECK_LIB(sasl, sasl_version_info, [SM_SASL_LIB="-lsasl"])
    AC_CHECK_LIB(sasl2, sasl_version_info, [SM_SASL_LIB="-lsasl2"])
    LIBS="$LIBS $SM_SASL_LIB"
    if test -d "$with_sasl_inc"; then
      CPPFLAGS="$CPPFLAGS -I$with_sasl_inc"
      SASL_INCADD="-I$with_sasl_inc"
    else
      SASL_INCADD=""
    fi
    AC_CHECK_HEADER(sasl/sasl.h,
		[SMX_SASL_INC=$SASL_INCADD; sm_cv_cyrus_saslhdr="yes"],
		[sm_cv_cyrus_saslhdr="no"])
    if test "$sm_cv_cyrus_saslhdr" = yes; then
    AC_CACHE_CHECK([for Cyrus SASL v2 availability],
      sm_cv_cyrus_saslv2,
      [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <sasl/sasl.h>

int main(int argc, char **argv)
{
	const char *implementation, *version_string;
	int r, version_major, version_minor, version_step, version_patch;

	sasl_version_info(&implementation, &version_string,
                          &version_major, &version_minor, &version_step,
                          &version_patch);
	if (version_major != 2)
		exit(1);
	r = sasl_server_init(NULL, "sendmail");
	exit(0);
}
>>changequote([, ]),
      sm_cv_cyrus_saslv2=yes,
      sm_cv_cyrus_saslv2=no,
      sm_cv_cyrus_saslv2=no
      )]
    )
    fi
    if test "$sm_cv_cyrus_saslv2" = yes; then
      SMX_SASL_LIB="$SASL_ADD_L $SM_SASL_LIB"
      AC_DEFINE(SM_USE_SASL, 1, [Define if SASL is available and should be used])
      AC_MSG_RESULT(enabled)
    else
      AC_MSG_RESULT(disabled due to failure in test compilation)
    fi
    LIBS=$SASL_SAVE_LIBS
    CFLAGS=$SASL_SAVE_CFLAGS
    LDFLAGS=$SASL_SAVE_LDFLAGS
    CPPFLAGS=$SASL_SAVE_CPPFLAGS
  else
    AC_MSG_RESULT(disabled)
  fi
  AC_SUBST(SMX_SASL_LIB)
  AC_SUBST(SMX_SASL_INC)
])


dnl ##########################################################################
dnl ###  SM_RES_QUERY_PROTOTYPE - check whether res_query prototype is available
dnl ##########################################################################

AC_DEFUN([SM_RES_QUERY_PROTOTYPE], [
  AC_CACHE_CHECK([check whether res_query prototype is available],
    sm_cv_res_query_prototype,
    AC_TRY_COMPILE([
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>],
	[
	int (*resfunc)(const char *, int, int, unsigned char *, int);
	resfunc = res_query;
	],
      sm_cv_res_query_prototype=yes,
      sm_cv_res_query_prototype=no
    )
  )
  if test "$sm_cv_res_query_prototype" = "yes"; then
    AC_DEFINE(HAVE_RES_QUERY_PROTOTYPE, 1, [Define if your system has res_query() prototype])
  fi
])


dnl ##########################################################################
dnl ###  SM_NEED_NAMESER_COMPAT_H - check whether nameser_compat.h is needed
dnl ##########################################################################

AC_DEFUN([SM_NEED_NAMESER_COMPAT_H], [
  AC_CHECK_HEADERS(arpa/nameser_compat.h)
  sm_cv_need_nameser_compat_h=no
  if test "$ac_cv_arpa_nameser_compat_h" = "yes"; then
  AC_CACHE_CHECK([check whether nameser_compat.h is needed],
    sm_cv_need_nameser_compat_h,
    [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <arpa/nameser.h>
#include <arpa/nameser_compt.h>

int main()
{
	int i;
	HEADER hp;

	i = T_MX;
	i += hp.qdcount;
	exit(0);
}
>>changequote([, ]),
      sm_cv_need_nameser_compat_h=yes,
      sm_cv_need_nameser_compat_h=no,
      sm_cv_need_nameser_compat_h=no
    )]
  )
  fi
  if test "$sm_cv_need_nameser_compat_h" = "yes"; then
    AC_DEFINE(HAVE_NAMESER_COMPAT, 1, [Define if your system needs arpa/nameser_compat.h])
  fi
])

dnl ##########################################################################
dnl ###  SM_SHA
dnl ##########################################################################

dnl check for SHA1
dnl AC_CHECK_HEADERS(sha1.h)
dnl AC_CHECK_FUNCS(SHA1Init SHA1Update SHA1Final)
dnl AC_CHECK_FUNCS(SHA1_Init SHA1_Update SHA1_Final)
dnl AC_CHECK_LIB(crypto, SHA1)

AC_DEFUN([SM_SHA], [
  SMX_SHA_LIB=""
  AC_CHECK_HEADERS(openssl/sha.h)
  if test "$ac_cv_header_openssl_sha_h" = "yes"; then
    SM_OLD_LIBS="$LIBS"
    LIBS="$LIBS -lcrypto"
    AC_CACHE_CHECK([check whether SHA1 works],
      sm_cv_sha1,
      [AC_TRY_RUN(
changequote(<<, >>)<<
#include <stdio.h>
#include <openssl/sha.h>

int main()
{
	unsigned char md[SHA_DIGEST_LENGTH];
	const char *d = "sha1 test";
	unsigned long n;

	n = strlen(d);
	SHA1(d, n, md);
	exit(0);
}
>>changequote([, ]),
      sm_cv_sha1=yes,
      sm_cv_sha1=no,
      sm_cv_sha1=no
      )]
    )
    if test "$sm_cv_sha1" = "yes"; then
      AC_DEFINE(HAVE_SHA1, 1, [Define if your system has a working SHA1() function])
      AC_CHECK_LIB(crypto, SHA1, SMX_SHA_LIB="-lcrypto", )
    fi
    LIBS="$SM_OLD_LIBS"
  fi
  AC_SUBST(SMX_SHA_LIB)
])

dnl ##########################################################################
dnl ###  SM_NEED_PROTO(includes, function)
dnl ##########################################################################

AC_DEFUN(SM_NEED_PROTO, [
if test "$ac_cv_func_$2" = yes; then
AC_CACHE_CHECK([if $2 needs a prototype], ac_cv_func_$2_noproto,
AC_TRY_COMPILE([$1],
[struct foo { int foo; } xx;
extern int $2 (struct foo*);
$2(&xx);
],
eval "ac_cv_func_$2_noproto=yes",
eval "ac_cv_func_$2_noproto=no"))
define([foo], [NEED_]translit($2, [a-z], [A-Z])[_PROTO])
if test "$ac_cv_func_$2_noproto" = yes; then
	AC_DEFINE(foo, 1, [define if the system is missing a prototype for $2()])
fi
undefine([foo])
fi
])


