#!/bin/sh
# $Id: t-t2821-0.sh,v 1.15 2005/04/29 17:32:05 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
#
IN=t2821_parse.in
OUT=t2821_parse.out
ERR=t2821_parse.err
ERRORS=0
./t-t2821-0 $@ > ${OUT} 2> ${ERR} <<EOF
<.@sendmail.org>
<a.@sendmail.org>
<sm9@sendmail.org>
<sm9.x@sendmail.org>
<sm9.x.@sendmail.org>
<@example.com:sm9@sendmail.org>
<@example.com,@endmail.org:sm9@sendmail.org>
<sm9@sendmail..org>
<sm9@sendmail.org.>
<s\m9@sendmail.org>
<\s\m9@sendmail.org>
<sm\@@sendmail.org>
<sm\.@sendmail.org>
<sm\.9@sendmail.org>
<"sm9"@sendmail.org>
<"s.9"@sendmail.org>
<"s-9"@sendmail.org>
<"s(9"@sendmail.org>
<"s 9"@sendmail.org>
<sm9@-endmail.org>
<sm9@sendmail-.org>
<sm9@sendmail.-org>
<sm9@sendmail.or-g>
<sm9@sendmail.or_g>
<sm9@sendmail.or!g>
EOF

cat > ${IN} <<EOF
>>><.@sendmail.org><<<
ERROR: 9b040206	>>><.@sendmail.org><<<
<.@sendmail.org>
>>><a.@sendmail.org><<<
ERROR: 9b04020b	>>><a.@sendmail.org><<<
<a.@sendmail.org>
>>><sm9@sendmail.org><<<
OK	>>><sm9@sendmail.org><<<
<sm9@sendmail.org>
>>><sm9.x@sendmail.org><<<
OK	>>><sm9.x@sendmail.org><<<
<sm9.x@sendmail.org>
>>><sm9.x.@sendmail.org><<<
ERROR: 9b04020b	>>><sm9.x.@sendmail.org><<<
<sm9.x.@sendmail.org>
>>><@example.com:sm9@sendmail.org><<<
OK	>>><@example.com:sm9@sendmail.org><<<
<sm9@sendmail.org>
>>><@example.com,@endmail.org:sm9@sendmail.org><<<
OK	>>><@example.com,@endmail.org:sm9@sendmail.org><<<
<sm9@sendmail.org>
>>><sm9@sendmail..org><<<
ERROR: 9b04020e	>>><sm9@sendmail..org><<<
<sm9@sendmail..org>
>>><sm9@sendmail.org.><<<
ERROR: 9b04020e	>>><sm9@sendmail.org.><<<
<sm9@sendmail.org.>
>>><s\m9@sendmail.org><<<
OK	>>><s\m9@sendmail.org><<<
<sm9@sendmail.org>
>>><\s\m9@sendmail.org><<<
OK	>>><\s\m9@sendmail.org><<<
<sm9@sendmail.org>
>>><sm\@@sendmail.org><<<
OK	>>><sm\@@sendmail.org><<<
<sm\@@sendmail.org>
>>><sm\.@sendmail.org><<<
OK	>>><sm\.@sendmail.org><<<
<sm\.@sendmail.org>
>>><sm\.9@sendmail.org><<<
OK	>>><sm\.9@sendmail.org><<<
<sm\.9@sendmail.org>
>>><"sm9"@sendmail.org><<<
OK	>>><"sm9"@sendmail.org><<<
<sm9@sendmail.org>
>>><"s.9"@sendmail.org><<<
OK	>>><"s.9"@sendmail.org><<<
<"s.9"@sendmail.org>
>>><"s-9"@sendmail.org><<<
OK	>>><"s-9"@sendmail.org><<<
<s-9@sendmail.org>
>>><"s(9"@sendmail.org><<<
OK	>>><"s(9"@sendmail.org><<<
<"s(9"@sendmail.org>
>>><"s 9"@sendmail.org><<<
OK	>>><"s 9"@sendmail.org><<<
<"s 9"@sendmail.org>
>>><sm9@-endmail.org><<<
ERROR: 9b040211	>>><sm9@-endmail.org><<<
<sm9@-endmail.org>
>>><sm9@sendmail-.org><<<
ERROR: 9b040211	>>><sm9@sendmail-.org><<<
<sm9@sendmail-.org>
>>><sm9@sendmail.-org><<<
ERROR: 9b040211	>>><sm9@sendmail.-org><<<
<sm9@sendmail.-org>
>>><sm9@sendmail.or-g><<<
OK	>>><sm9@sendmail.or-g><<<
<sm9@sendmail.or-g>
>>><sm9@sendmail.or_g><<<
ERROR: 9b040211	>>><sm9@sendmail.or_g><<<
<sm9@sendmail.or_g>
>>><sm9@sendmail.or!g><<<
ERROR: 9b040211	>>><sm9@sendmail.or!g><<<
<sm9@sendmail.or!g>
EOF

diff ${OUT} ${IN}
if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1 `
fi

if test ${ERRORS} -eq 0
then
  rm -f ${IN} ${OUT} ${ERR}
fi
exit ${ERRORS}
