#!/bin/sh
# $Id: t-smtpf1.sh,v 1.17 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling from different components
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
EDBROK="../qmgr/t-smtpf1-edbr.ok"
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

# run some test programs

TEST=1
# ----------------------------------------
# fail over to HELO (how to check whether this actually happened?)
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Y '-E 502' -E 1 -S"a1@b.c" -R"x1@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

TEST=2
# ----------------------------------------
# temporary failure from SMTP sink during greeting
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<a2@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<x2@y.z>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=451
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -Y '-G 451' -O ${EDBROK} -E 0 -A 1 -X 0 -S"a2@b.c" -R"x2@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    ERRS=`expr ${ERRS} + 1 `
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# 
# ----------------------------------------
# permanent failure from SMTP sink during greeting
# NOT YET ready for testing.
# TEST=3
# ${CAT} > ${EDBROK} <<EOF
# got transaction
# 	mail=<a3@b.c>
# 	rcpts_tot=1
# 	rcpts_left=1
# 	rcpts_temp=1
# 	rcpts_perm=0
# 	state=551
# 	aqt_rcpts_ar=0
# got recipient
# 	rcpt=<x3@y.z>
# 	aqr_rcpt_idx=0
# 	aqr_da_idx=0
# 	aqr_status=551
# EOF
# if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
# then
# if ${SHELL} ${SD}/smtp1.sh $@ -Y '-G 551' -O ${EDBROK} -E 0 -A 1 -X 0 -S"a3@b.c" -R"x3@y.z"
# then
#     ${VERBOSE} && echo "test ${TEST} succeeded"
# else
#     echo "$0: test ${TEST} failed"
#     ERRS=`expr ${ERRS} + 1 `
#     test X"${SM_STOPONERROR}" != X && exit 1
# fi
# fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${EDBROK}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
