/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: ctype.h,v 1.5 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_CTYPE_H
#define SM_CTYPE_H 1

#include <ctype.h>

/*
**  On some systems, ctype.h misbehaves with non-ASCII or negative characters.
*/

#if HAVE_UNSIGNED_CHAR
# define UCHAR_CAST
#else /* HAVE_UNSIGNED_CHAR */
# define UCHAR_CAST	(uchar)
#endif /* HAVE_UNSIGNED_CHAR */

#if HAVE_SAFE_CTYPE
#define ISASCII(c)	isascii(UCHAR_CAST(c))
#define ISALNUM(c)	isalnum(UCHAR_CAST(c))
#define ISALPHA(c)	isalpha(UCHAR_CAST(c))
#define ISCNTRL(c)	iscntrl(UCHAR_CAST(c))
#define ISDIGIT(c)	isdigit(UCHAR_CAST(c))
#define ISXDIGIT(c)	isxdigit(UCHAR_CAST(c))
#define ISGRAPH(c)	isgraph(UCHAR_CAST(c))
#define ISLOWER(c)	islower(UCHAR_CAST(c))
#define ISPRINT(c)	isprint(UCHAR_CAST(c))
#define ISPUNCT(c)	ispunct(UCHAR_CAST(c))
#define ISSPACE(c)	isspace(UCHAR_CAST(c))
#define ISUPPER(c)	isupper(UCHAR_CAST(c))
#define TOLOWER(c)	tolower(UCHAR_CAST(c))
#define TOUPPER(c)	toupper(UCHAR_CAST(c))
#else /* HAVE_SAFE_CTYPE */
#define ISASCII(c)	isascii(UCHAR_CAST(c))
#define ISALNUM(c)	(ISASCII(c) && isalnum(c))
#define ISALPHA(c)	(ISASCII(c) && isalpha(c))
#define ISCNTRL(c)	(ISASCII(c) && iscntrl(c))
#define ISDIGIT(c)	(ISASCII(c) && isdigit(c))
#define ISXDIGIT(c)	(ISASCII(c) && isxdigit(c))
#define ISGRAPH(c)	(ISASCII(c) && isgraph(c))
#define ISLOWER(c)	(ISASCII(c) && islower(c))
#define ISPRINT(c)	(ISASCII(c) && isprint(c))
#define ISPUNCT(c)	(ISASCII(c) && ispunct(c))
#define ISSPACE(c)	(ISASCII(c) && isspace(c))
#define ISUPPER(c)	(ISASCII(c) && isupper(c))
#define TOLOWER(c)	(ISUPPER(c) ? tolower(c) : (c))
#define TOUPPER(c)	(ISLOWER(c) ? toupper(c) : (c))
#endif /* HAVE_SAFE_CTYPE */

#endif /* SM_CTYPE_H */
