/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: memops.h,v 1.7 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_MEMOPS_H
#define SM_MEMOPS_H 1

#include "sm/generic.h"

#if HAVE_STRING_H
# include <string.h>
#endif /* HAVE_STRING_H */

#if HAVE_MEMSET
# define sm_memzero(b, l)	memset(b, 0, l)
# define sm_memset(b, v, l)	memset(b, v, l)
#else /* HAVE_MEMSET */
# define sm_memzero(b, l)	bzero(b, l)
#endif /* HAVE_MEMSET */

#if HAVE_MEMCMP
# define sm_memcmp(b1, b2, l)	memcmp(b1, b2, l)
# define sm_memeq(b1, b2, l)	(memcmp(b1, b2, l) == 0)
#else /* HAVE_MEMCMP */
# define sm_memeq(b1, b2, l)	(bcmp(b1, b2, l) == 0)
/* sm_memcmp() available in librepl */
#endif /* HAVE_MEMCMP */

/* do not use this for overlapping buffers */
#if HAVE_MEMCPY
# define sm_memcpy(dst, src, l)	memcpy(dst, src, l)
#else /* HAVE_MEMCPY */
# define sm_memcpy(dst, src, l)	bcopy(src, dst, l)
#endif /* HAVE_MEMCPY */

#if HAVE_MEMMOVE
# define sm_memmove(dst, src, l)	memmove(dst, src, l)
#else /* HAVE_MEMMOVE */
# define sm_memmove(dst, src, l)	bcopy(src, dst, l)
#endif /* HAVE_MEMMOVE */

bool	sm_memcaseeq(const void *_s1, const void *_s2, size_t _len);
bool	sm_memncaseeq(const void *_s1, size_t _l1, const void *_s2, size_t _l2);

#endif /* ! SM_MEMOPS_H */
