/*
 * Copyright (c) 2000-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: str-int.h,v 1.14 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_STR_INT_H
#define SM_STR_INT_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/error.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"

/* maximum length of a buf */
#ifndef SM_STR_MAX_LEN
# if defined(SIZE_T_MAX) && SIZE_T_MAX < UINT32_MAX
#  define SM_STR_MAX_LEN	(SIZE_T_MAX >> 4)
# else /* defined(SIZE_T_MAX) && SIZE_T_MAX < UINT32_MAX */
#  define SM_STR_MAX_LEN	(UINT32_MAX >> 8)
# endif /* defined(SIZE_T_MAX) && SIZE_T_MAX < UINT32_MAX */
# if SM_STR_MAX_LEN < 32768
#  define SM_STR_MAX_LEN	32768
# endif /* SM_STR_MAX_LEN < 32768 */
#endif /* ! SM_STR_MAX_LEN */

#define SM_IS_BUF(str)	SM_REQUIRE_ISA((str), SM_STR_MAGIC)

/* increase the length of a buf, if too long: return error */
#define SM_STR_INCREASE_R(str, new_alloc)			\
	do {							\
		sm_ret_T ret;					\
		if ((new_alloc) > (str)->sm_str_max)		\
			return sm_error_perm(SM_EM_STR, SM_E_OVFLW_NS);\
		if ((new_alloc) * 2 < (str)->sm_str_max)	\
			(new_alloc) *= 2;			\
		else						\
			(new_alloc) = (str)->sm_str_max;	\
		ret = sm_str_resize_data(str, new_alloc);	\
		if (sm_is_err(ret))				\
			return ret;				\
	} while (0)

/* increase the length of a buf, if too long: return NULL */
#define SM_STR_INCREASE_N_R(str, new_alloc)			\
	do {							\
		if ((new_alloc) > (str)->sm_str_max)		\
			return NULL;				\
		if ((new_alloc) * 2 < (str)->sm_str_max)	\
			(new_alloc) *= 2;			\
		else						\
			(new_alloc) = (str)->sm_str_max;	\
		if (sm_is_err(sm_str_resize_data(str, new_alloc)))	\
			return NULL;				\
	} while (0)

#endif /* SM_STR_INT_H */
