/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: str.h,v 1.47 2003/12/28 23:46:24 ca Exp $
 */

#ifndef SM_STRTEMPLATE_H
#define SM_STRTEMPLATE_H 1

#include "sm/generic.h"
#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/ctype.h"
#include "sm/str-int.h"

/*
**  SM_STR_TEMPLATE_TOKEN -- Definition table for templates
*/

typedef struct sm_template_tk_S	sm_template_tk_T, *sm_template_tk_P;

struct sm_template_tk_S
{
	uchar		tmpl_tk;
	sm_str_P	tmpl_value;
};

/*
**  SM_STR_TEMPLATE_SET -- Opaque data structure
*/

typedef struct sm_template_set_S	sm_template_set_T, *sm_template_set_P;


sm_ret_T	 sm_template_expand(const sm_str_P src, sm_str_P dst, uchar tk_start, sm_template_set_P templates);
sm_ret_T	 sm_template_new(uint num, sm_template_set_P *ptemplates);
void		 sm_template_free(sm_template_set_P tmpl);
uint	 sm_template_ntks(sm_template_set_P temp);
sm_ret_T	 sm_template_remove(sm_template_set_P temp, uchar tk);
sm_template_tk_P sm_template_tks(sm_template_set_P temp);
sm_ret_T	 sm_template_update(sm_template_set_P temp, uchar tk, sm_str_P value);

#endif /* SM_STRTEMPLATE_H */
