/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strc.c,v 1.19 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_DUP -- Make a copy of a str, creates a new str
**
**	Parameters:
**		rpool -- rpool for new str
**		src -- sm_str_P object to copy
**
**	Returns:
**		pointer to new str
*/

sm_str_P
sm_str_dup(sm_rpool_P rpool, const sm_str_P src)
{
	sm_str_P dst;

	SM_IS_BUF(src);
	dst = sm_str_new(rpool, src->sm_str_len, src->sm_str_max);
	if (dst == NULL)
		return NULL;
	sm_memcpy(dst->sm_str_base, src->sm_str_base, src->sm_str_len);
	dst->sm_str_len = src->sm_str_len;
	return dst;
}

/*
**  SM_STR_CPY -- copy str str to str dst (only if enough space)
**	XXX: cut off or copy not at all?
**
**	Parameters:
**		dst -- str destination
**		src -- str source
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_SC, SM_E_OVFLW_NS
*/

sm_ret_T
sm_str_cpy(sm_str_P dst, const sm_str_P src)
{
	uint sl;

	SM_IS_BUF(src);
	SM_IS_BUF(dst);
	sl = src->sm_str_len;
	if (sl > dst->sm_str_max)
		return sm_error_perm(SM_EM_STR, SM_E_OVFLW_NS);
	if (sl > dst->sm_str_size)
		SM_STR_INCREASE_R(dst, sl);
	sm_memcpy(dst->sm_str_base, src->sm_str_base, sl);
	dst->sm_str_len = sl;
	return SM_SUCCESS;
}

/*
**  SM_STR_CATV -- Append multiple str to dst
**	This version stops when the copying fails, creating a partial copy.
**
**	Parameters:
**		dst -- str destination
**		n -- number of source str
**		... -- str to append
**		(should we use NULL as end marker instead?)
**
**	Returns:
**		usual sm_ret_T
*/

sm_ret_T
sm_str_catv(sm_str_P dst, int n, ...)
{
	sm_str_P str;
	sm_ret_T res;
	va_list ap;

	SM_IS_BUF(dst);
	va_start(ap, n);

	/* loop through all source strings */
	while (n-- > 0)
	{
		str = va_arg(ap, sm_str_P);
		SM_IS_BUF(str);
		res = sm_str_cat(dst, str);
		if (sm_is_err(res))
		{
			va_end(ap);
			return res;
		}
	}
	va_end(ap);
	return SM_SUCCESS;
}
