/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strfree.c,v 1.10 2005/02/18 02:34:15 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"

/*
**  SM_STR_FREE -- Frees a buf structure.
**
**      Releases resources held by a buf (if it was allocated
**	in a releasable way).
**
**	Parameters:
**		str -- sm_str_P object to free.
**
**	Returns:
**		none.
*/

void
sm_str_free(sm_str_P str)
{
	SM_IS_BUF(str);
	if (str->sm_str_base != NULL)
		sm_rpool_free_size(str->sm_str_rpool, str->sm_str_base,
				str->sm_str_size);
	str->sm_magic = SM_MAGIC_NULL;
	sm_rpool_free_size(str->sm_str_rpool, str, sizeof(*str));
}
