/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strput.c,v 1.8 2005/02/25 02:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"

/*
**  SM_STR_PUT -- Append one char onto the end of str.
**
**	Parameters:
**		str -- sm_str_P object to append onto.
**		c - Character to append.
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_SC, SM_E_OVFLW_NS
*/

sm_ret_T
sm_str_put(sm_str_P str, uchar c)
{
	SM_IS_BUF(str);

	if (str->sm_str_len == str->sm_str_size)
	{
		size_t new_alloc;

		new_alloc = str->sm_str_len + 1;

		/* overflow? */
		if (new_alloc < str->sm_str_len)
			return sm_error_perm(SM_EM_STR_RCB, SM_E_OVFLW_SC);
		SM_STR_INCREASE_R(str, new_alloc);
	}
	str->sm_str_base[str->sm_str_len] = c;
	str->sm_str_len++;
	return SM_SUCCESS;
}
