/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: stsockspec.c,v 1.2 2005/08/25 23:43:24 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "statethreads/st.h"
#include "sm/rcbst.h"
#include "sm/fcntl.h"
#include "sm/socket.h"
#include "sm/sockcnf.h"
#include "sm/stsock.h"

/*
**  ST_SOCK_CONNECT -- connect to a socket
**
**	Parameters:
**		sockspec -- socket specification
**		tmo -- timeout
**		fd -- pointer to net fd (output)
**
**	Returns:
**		usual return code
*/

sm_ret_T
st_sock_connect(sockspec_P sockspec, st_utime_t tmo, st_netfd_t *fd)
{
	int sockfd;
	st_netfd_t nfd;
	sockaddr_len_T sock_size;
	sm_sockaddr_T sm_sockaddr;

	SM_REQUIRE(sockspec != NULL);
	SM_REQUIRE(fd != NULL);

	*fd = NULL;	/* be nice to callers (in case of errors) */
	sm_memset(&sm_sockaddr, 0, sizeof(sm_sockaddr));
	sockfd = INVALID_SOCKET;
	switch (sockspec->sckspc_type)
	{
	  case SOCK_TYPE_INET:
		sm_sockaddr.sin.sin_family = AF_INET;
		sm_sockaddr.sin.sin_addr.s_addr =
				sockspec->sock_inet.inetsckspc_addr;
		sm_sockaddr.sin.sin_port = htons((unsigned short)
				sockspec->sock_inet.inetsckspc_port);
		sock_size = sizeof(sm_sockaddr.sin);
		break;

	  case SOCK_TYPE_UNIX:
		{
		size_t len;

		sm_sockaddr.sunix.sun_family = AF_UNIX;
		len = strlcpy(sm_sockaddr.sunix.sun_path,
			sockspec->sock_unix.unixsckspc_path,
			sizeof(sm_sockaddr.sunix.sun_path));
		if (len <= 0 || len >= sizeof(sm_sockaddr.sunix.sun_path))
			return sm_error_perm(SM_EM_STTHRIO, SM_E_2BIG);
#if HAVE_SOCK_UN_SUN_LEN
		sm_sockaddr.sunix.sun_len =
				strlen(sockspec->sock_unix.unixsckspc_path);
#endif
		sock_size = sizeof(sm_sockaddr.sunix);
		break;
		}
	  default:
		return sm_error_perm(SM_EM_STTHRIO, EINVAL);
	}

	sockfd = socket(sm_sockaddr.sa.sa_family, SOCK_STREAM, 0);
	if (sockfd == -1)
		return sm_error_perm(SM_EM_STTHRIO, errno);

	nfd = st_netfd_open_socket(sockfd);
	if (nfd == NULL)
		return sm_error_perm(SM_EM_STTHRIO, errno);
	if (st_connect(nfd, (struct sockaddr *) &(sm_sockaddr.sa),
		     sock_size, tmo) == -1)
	{
		int err;

		err = errno;
		(void) st_netfd_close(nfd);
		return sm_error_perm(SM_EM_STTHRIO, err);
	}

	*fd = nfd;
	return SM_SUCCESS;
}
