#!/bin/sh
# $Id: t-alias-2.sh,v 1.15 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses.
# Uses smar, t-smar-1, "aliases" map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=alias-2.out
RES=alias-2.ip
GEN=alias-2.gen
OK=alias-2.ok
TPRG=./t-smar-1
ALIAS=alias-2
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
x.y	[1.2.3.4]
y.z	[2.3.4.5]
other.dom	[3.4.5.6]
EOF

# number of RHS entries for alias map
for ENTRIES in 50 100 200 500
do
TOTAL=`expr ${ENTRIES} + 2`

# create map for smar
rm -f ${ALIAS} ${ALIMAP} ${GEN}
printf "long:" > ${ALIAS}
i=0
while test ${i} -le ${ENTRIES}
do
printf "<e${i}@other.dom> " >> ${ALIAS}
# printf "address <e%d@other.dom> flags: 4000\n" ${i} >> ${GEN}
printf "alias %d/%d\n" ${i} ${TOTAL} >> ${GEN}
printf "aliased=<e%d@other.dom>\n" ${i} >> ${GEN}
printf "IP[0]=3.4.5.6 [3040506]\n" >> ${GEN}
i=`expr ${i} + 1 `
done

printf "<e@other.dom>\n" >> ${ALIAS}
printf "alias %d/%d\n" ${i} ${TOTAL} >> ${GEN}
printf "aliased=<e@other.dom>\n" >> ${GEN}
printf "IP[0]=3.4.5.6 [3040506]\n" >> ${GEN}
printf "aliases=%d\n" ${TOTAL} >> ${GEN}
sort ${GEN} > ${OK}

${MM} < ${ALIAS}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES}

# Problem: the output isn't ordered (asynchronous operation, and
# hash table to list conversion).

# check output somehow...
${VALGRIND} ${TPRG} -VVV '<long@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} |sort > ${RES}
if diff -w ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && killit
  break
fi


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

# for ENTRIES
done

rm -f ${MTMAP}

exit ${ERRS}
