/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

public class BitReader {
    private final byte[] buf;
    private int bitPosition;

    public BitReader(byte[] buf) {
        this.buf = buf;
    }

    public boolean get1() {
        int off = this.bitPosition % 8;
        byte b = this.buf[this.bitPosition / 8];
        ++this.bitPosition;
        return (b >> off & 1) == 1;
    }

    public int get(int n) {
        int res = 0;
        int pos = 0;
        while (pos < n) {
            int index = this.bitPosition / 8;
            int off = this.bitPosition % 8;
            byte b = this.buf[index];
            b = (byte)(b >> off);
            int nbits = n - pos;
            if (nbits > 8 - off) {
                nbits = 8 - off;
            }
            int mask = (1 << nbits) - 1;
            res |= (b & mask) << pos;
            pos += nbits;
            this.bitPosition += nbits;
        }
        return res;
    }

    public int sget(int n) {
        int top;
        int res = this.get(n);
        if ((res & (top = 1 << n - 1)) != 0) {
            int mask = top - 1;
            res = ~mask | res;
        }
        return res;
    }

    public int sget2(int n) {
        int top = 1 << n - 1;
        int mask = top - 1;
        int base = 0;
        int res = this.get(n);
        while (res == top) {
            base += mask;
            res = this.get(n);
        }
        res = (res & top) == 0 ? (res += base) : (res | ~mask) - base;
        return res;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    public int getNumberOfBits() {
        return this.buf.length * 8;
    }

    public String remainder() {
        int save = this.bitPosition;
        StringBuilder sb = new StringBuilder();
        while (this.bitPosition < this.buf.length * 8) {
            sb.insert(0, this.get1() ? "1" : "0");
        }
        this.bitPosition = save;
        return sb.toString();
    }
}

