/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import uk.me.parabola.log.Logger;

public class BitWriter {
    private static final Logger log = Logger.getLogger(BitWriter.class);
    private static final int INITIAL_BUF_SIZE = 20;
    private byte[] buf = new byte[this.bufsize];
    private int bufsize = 20;
    private int buflen;
    private int bitoff;
    private static final int BUFSIZE_INC = 50;

    private void put1(int b) {
        this.ensureSize(this.bitoff + 1);
        int off = this.getByteOffset(this.bitoff);
        int rem = this.bitoff - 8 * off;
        int n = off;
        this.buf[n] = (byte)(this.buf[n] | (b & 1) << rem);
        ++this.bitoff;
        if ((this.bitoff & 7) == 1) {
            ++this.buflen;
        }
        this.debugPrint(b, 1);
    }

    public void put1(boolean b) {
        this.put1(b ? 1 : 0);
    }

    public void putn(int bval, int nb) {
        int val = bval & (1 << nb) - 1;
        int n = nb;
        if (n >= 24) {
            throw new IllegalArgumentException();
        }
        this.ensureSize(this.bitoff + n);
        while (n > 0) {
            int ind = this.getByteOffset(this.bitoff);
            int rem = this.bitoff - 8 * ind;
            int n2 = ind;
            this.buf[n2] = (byte)(this.buf[n2] | val << rem & 0xFF);
            val >>>= 8 - rem;
            int nput = 8 - rem;
            if (nput > n) {
                nput = n;
            }
            this.bitoff += nput;
            n -= nput;
        }
        this.buflen = (this.bitoff + 7) / 8;
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public int getLength() {
        return this.buflen;
    }

    private int getByteOffset(int boff) {
        return boff / 8;
    }

    private void ensureSize(int newlen) {
        if (newlen / 8 >= this.bufsize) {
            this.reallocBuffer();
        }
    }

    private void reallocBuffer() {
        log.debug((Object)"reallocating buffer");
        this.bufsize += 50;
        byte[] newbuf = new byte[this.bufsize];
        System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
        this.buf = newbuf;
    }

    private void debugPrint(int b, int i) {
        if (log.isDebugEnabled()) {
            log.debug("after put", i, "of", b, " bufsize=", this.bufsize, ", len=", this.buflen, ", pos=", this.bitoff);
        }
    }
}

