/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;

public abstract class CommonHeader {
    protected static final int COMMON_HEADER_LEN = 21;
    private static final int TYPE_LEN = 10;
    private int headerLength;
    private String type;
    private Date creationDate;

    protected CommonHeader(int headerLength, String type) {
        this.headerLength = headerLength;
        this.type = type;
    }

    public final void writeHeader(ImgFileWriter writer) {
        this.writePrepare();
        writer.position(0L);
        writer.putChar((char)this.headerLength);
        writer.put(Utils.toBytes(this.type, 10, (byte)0));
        writer.put((byte)1);
        writer.put((byte)0);
        byte[] date = Utils.makeCreationTime(new Date());
        writer.put(date);
        this.writeFileHeader(writer);
    }

    public final void readHeader(ImgFileReader reader) throws ReadFailedException {
        reader.position(0L);
        this.headerLength = reader.getChar();
        byte[] bytes = reader.get(10);
        try {
            this.type = new String(bytes, "ascii");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        reader.get();
        reader.get();
        byte[] date = reader.get(7);
        this.creationDate = Utils.makeCreationTime(date);
        this.readFileHeader(reader);
    }

    protected abstract void readFileHeader(ImgFileReader var1) throws ReadFailedException;

    protected abstract void writeFileHeader(ImgFileWriter var1);

    public int getHeaderLength() {
        return this.headerLength;
    }

    private void writePrepare() {
        if (this.creationDate == null) {
            this.creationDate = new Date();
        }
    }
}

