/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.util.Locale;
import uk.me.parabola.imgfmt.app.labelenc.BaseEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;
import uk.me.parabola.imgfmt.app.labelenc.TableTransliterator;
import uk.me.parabola.imgfmt.app.labelenc.Transliterator;

public class Format6Encoder
extends BaseEncoder
implements CharacterEncoder {
    private static final int SYMBOL_SHIFT = 28;
    public static final String LETTERS = " ABCDEFGHIJKLMNOPQRSTUVWXYZxx   0123456789\u0001\u0002\u0003\u0004\u0005\u0006";
    public static final String SYMBOLS = "@!\"#$%&'()*+,-./xxxxxxxxxx:;<=>?xxxxxxxxxxx[\\]^_";
    private final Transliterator transliterator = new TableTransliterator("ascii");

    @Override
    public EncodedText encodeText(String text) {
        if (text == null || text.isEmpty()) {
            return NO_TEXT;
        }
        String s = this.transliterator.transliterate(text).toUpperCase(Locale.ENGLISH);
        byte[] buf = new byte[2 * s.length() + 4];
        int off = 0;
        for (char c : s.toCharArray()) {
            if (c == ' ') {
                this.put6(buf, off++, 0);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                this.put6(buf, off++, c - 65 + 1);
                continue;
            }
            if (c >= '0' && c <= '9') {
                this.put6(buf, off++, c - 48 + 32);
                continue;
            }
            if (c == '\u001b' || c == '\u001c') {
                this.put6(buf, off++, 27);
                this.put6(buf, off++, c + 16);
                continue;
            }
            if (c >= '\u001d' && c <= '\u001f') {
                this.put6(buf, off++, c);
                continue;
            }
            if (c >= '\u0001' && c <= '\u0006') {
                this.put6(buf, off++, 41 + c);
                continue;
            }
            off = this.shiftedSymbol(buf, off, c);
        }
        buf = this.put6(buf, off++, 255);
        int len = (off - 1) * 6 / 8 + 1;
        char[] chars = s.toCharArray();
        return new EncodedText(buf, len, chars);
    }

    private int shiftedSymbol(byte[] buf, int startOffset, char c) {
        int off = startOffset;
        int ind = SYMBOLS.indexOf(c);
        if (ind >= 0) {
            this.put6(buf, off++, 28);
            this.put6(buf, off++, ind);
        }
        return off;
    }

    private byte[] put6(byte[] buf, int off, int c) {
        int bitOff = off * 6;
        int byteOff = bitOff / 8;
        int shift = bitOff - 8 * byteOff;
        int mask = 252 >> shift;
        int n = byteOff;
        buf[n] = (byte)(buf[n] | c << 2 >> shift & mask);
        if (shift > 2) {
            mask = 252 << 8 - shift;
            buf[byteOff + 1] = (byte)(c << 2 << 8 - shift & mask);
        }
        return buf;
    }
}

