/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Locale;
import uk.me.parabola.imgfmt.app.labelenc.Transliterator;
import uk.me.parabola.log.Logger;

public class TableTransliterator
implements Transliterator {
    private static final Logger log = Logger.getLogger(TableTransliterator.class);
    private final String[][] rows = new String[256][];
    private final boolean useLatin;
    private boolean forceUppercase;

    public TableTransliterator(String targetCharset) {
        this.useLatin = targetCharset.equals("latin1") || targetCharset.equals("cp1252");
    }

    @Override
    public String transliterate(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length() + 5);
        for (char c : s.toCharArray()) {
            if (c <= (this.useLatin ? (char)'\u00ff' : '\u007f')) {
                sb.append(c);
                continue;
            }
            int row = c >>> 8;
            String[] rowmap = this.rows[row];
            if (rowmap == null) {
                rowmap = this.loadRow(row);
            }
            sb.append(rowmap[c & 0xFF]);
        }
        String text = sb.toString();
        if (this.forceUppercase) {
            text = text.toUpperCase(Locale.ENGLISH);
        }
        return text;
    }

    @Override
    public void forceUppercase(boolean uc) {
        this.forceUppercase = uc;
    }

    private String[] loadRow(int row) {
        String name;
        if (this.rows[row] != null) {
            return this.rows[row];
        }
        Object[] newRow = new String[256];
        this.rows[row] = newRow;
        Arrays.fill(newRow, "?");
        if (this.useLatin) {
            name = String.format("/chars/latin1/row%02x.trans", row);
            this.readCharFile(name, (String[])newRow);
        }
        name = String.format("/chars/ascii/row%02x.trans", row);
        this.readCharFile(name, (String[])newRow);
        return newRow;
    }

    private void readCharFile(String name, String[] newRow) {
        InputStream is = this.getClass().getResourceAsStream(name);
        if (is == null) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            while ((line = br.readLine()) != null) {
                int index;
                String[] fields;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || (fields = line.split("\\s+")).length < 2) continue;
                String upoint = fields[0];
                String translation = fields[1];
                if ("?".equals(translation) || upoint.length() != 6 || upoint.charAt(0) != 'U' || !newRow[index = Integer.parseInt(upoint.substring(4), 16)].equals("?")) continue;
                if (this.forceUppercase) {
                    newRow[index] = translation.toUpperCase(Locale.ENGLISH);
                    continue;
                }
                newRow[index] = translation;
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not read character translation table");
        }
    }
}

