/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr10Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;

public class Mdr10
extends MdrMapSection {
    private static final int MAX_GROUP_NUMBER = 9;
    private List<Mdr10Record>[] poiTypes = new ArrayList[10];
    private int numberOfPois;

    public Mdr10(MdrConfig config) {
        this.setConfig(config);
        for (int i = 1; i <= 9; ++i) {
            this.poiTypes[i] = new ArrayList<Mdr10Record>();
        }
    }

    public void addPoiType(Mdr11Record poi) {
        Mdr10Record t = new Mdr10Record();
        int type = poi.getType();
        t.setSubtype(MdrUtils.getSubtypeOrTypeFromFullType(type));
        t.setMdr11ref(poi);
        int group = MdrUtils.getGroupForPoi(type);
        if (group == 0) {
            return;
        }
        this.poiTypes[group].add(t);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int count = 0;
        for (List<Mdr10Record> poiGroup : this.poiTypes) {
            if (poiGroup == null) continue;
            Collections.sort(poiGroup);
            String lastName = null;
            int lastSub = -1;
            for (Mdr10Record t : poiGroup) {
                Mdr11Record mdr11ref = t.getMdr11ref();
                this.addIndexPointer(mdr11ref.getMapIndex(), ++count);
                writer.put((byte)t.getSubtype());
                int offset = mdr11ref.getRecordNumber();
                String name = mdr11ref.getName();
                boolean isNew = !name.equals(lastName) || t.getSubtype() != lastSub;
                this.putPoiIndex(writer, offset, isNew);
                lastName = name;
                lastSub = t.getSubtype();
            }
        }
    }

    public Map<Integer, Integer> getGroupSizes() {
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        for (int i = 1; i < 9; ++i) {
            List<Mdr10Record> poiGroup = this.poiTypes[i];
            if (poiGroup.isEmpty()) continue;
            m.put(i, poiGroup.size());
        }
        return m;
    }

    @Override
    public int getItemSize() {
        return 0;
    }

    @Override
    protected int numberOfItems() {
        return this.numberOfPois;
    }

    public void setNumberOfPois(int numberOfPois) {
        this.numberOfPois = numberOfPois;
    }

    @Override
    protected void releaseMemory() {
        this.poiTypes = null;
    }

    @Override
    public int getExtraValue() {
        return 0;
    }

    @Override
    public void relabelMaps(Mdr1 maps) {
    }
}

