/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.NamedRecord;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class MdrUtils {
    public static final int STREET_INDEX_PREFIX_LEN = 4;
    public static final int POI_INDEX_PREFIX_LEN = 4;

    public static int getGroupForPoi(int fullType) {
        int type = MdrUtils.getTypeFromFullType(fullType);
        int group = 0;
        if (fullType < 15) {
            group = 1;
        } else if (type >= 42 && type <= 48) {
            group = type - 40;
        } else if (type == 40) {
            group = 9;
        }
        return group;
    }

    public static boolean canBeIndexed(int fullType) {
        return MdrUtils.getGroupForPoi(fullType) != 0;
    }

    private static int getTypeFromFullType(int fullType) {
        if ((fullType & 0xFFF00) > 0) {
            return fullType >> 8 & 0xFFF;
        }
        return fullType & 0xFF;
    }

    public static int getSubtypeOrTypeFromFullType(int fullType) {
        return fullType & 0xFF;
    }

    public static <T extends NamedRecord> List<SortKey<T>> sortList(Sort sort, List<T> list) {
        ArrayList<SortKey<T>> toSort = new ArrayList<SortKey<T>>(list.size());
        for (NamedRecord m : list) {
            SortKey<NamedRecord> sortKey = sort.createSortKey(m, m.getName(), m.getMapIndex());
            toSort.add(sortKey);
        }
        Collections.sort(toSort);
        return toSort;
    }

    public static int fullTypeToNaturalType(int ftype) {
        int type = MdrUtils.getTypeFromFullType(ftype);
        int sub = 0;
        if ((ftype & 0xFFFFFF00) != 0) {
            sub = ftype & 0x1F;
        }
        return type << 5 | sub;
    }
}

