/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

public enum NumberStyle {
    NONE(0),
    EVEN(1){

        @Override
        public int round(int val, int direction) {
            if ((val & 1) == 1) {
                return val + direction;
            }
            return val;
        }
    }
    ,
    ODD(2){

        @Override
        public int round(int val, int direction) {
            if ((val & 1) == 0) {
                return val + direction;
            }
            return val;
        }
    }
    ,
    BOTH(3);

    private final int val;

    private NumberStyle(int val) {
        this.val = val;
    }

    public int getVal() {
        return this.val;
    }

    public int round(int val, int direction) {
        return val;
    }

    public static NumberStyle fromInt(int n) {
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EVEN;
            }
            case 2: {
                return ODD;
            }
            case 3: {
                return BOTH;
            }
        }
        return NONE;
    }

    public String toString() {
        return super.toString().substring(0, 1);
    }

    public static NumberStyle fromChar(String string) {
        switch (string.charAt(0)) {
            case 'N': {
                return NONE;
            }
            case 'E': {
                return EVEN;
            }
            case 'O': {
                return ODD;
            }
            case 'B': {
                return BOTH;
            }
            case '0': {
                System.err.println("zero instead of capital O in number spec");
                return ODD;
            }
        }
        return NONE;
    }
}

