/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.log.Logger;

public class Numbers {
    private static final Logger log = Logger.getLogger(Numbers.class);
    private int nodeNumber;
    private Integer rnodNumber;
    private NumberStyle leftNumberStyle;
    private int leftStart;
    private int leftEnd;
    private NumberStyle rightNumberStyle;
    private int rightStart;
    private int rightEnd;

    public Numbers() {
    }

    public Numbers(String spec) {
        String[] strings = spec.split(",");
        this.nodeNumber = Integer.valueOf(strings[0]);
        this.leftNumberStyle = NumberStyle.fromChar(strings[1]);
        this.leftStart = Integer.valueOf(strings[2]);
        this.leftEnd = Integer.valueOf(strings[3]);
        this.rightNumberStyle = NumberStyle.fromChar(strings[4]);
        this.rightStart = Integer.valueOf(strings[5]);
        this.rightEnd = Integer.valueOf(strings[6]);
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public void setNodeNumber(int nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    public int getRnodNumber() {
        if (this.rnodNumber == null) {
            log.error((Object)"WARNING: rnod not set!!");
            return this.nodeNumber;
        }
        return this.rnodNumber;
    }

    public boolean hasRnodNumber() {
        return this.rnodNumber != null;
    }

    public void setRnodNumber(int rnodNumber) {
        this.rnodNumber = rnodNumber;
    }

    public NumberStyle getLeftNumberStyle() {
        return this.leftNumberStyle;
    }

    public void setLeftNumberStyle(NumberStyle leftNumberStyle) {
        this.leftNumberStyle = leftNumberStyle;
    }

    public int getLeftStart() {
        return this.leftStart;
    }

    public void setLeftStart(int leftStart) {
        this.leftStart = leftStart;
    }

    public int getLeftEnd() {
        return this.leftEnd;
    }

    public void setLeftEnd(int leftEnd) {
        this.leftEnd = leftEnd;
    }

    public NumberStyle getRightNumberStyle() {
        return this.rightNumberStyle;
    }

    public void setRightNumberStyle(NumberStyle rightNumberStyle) {
        this.rightNumberStyle = rightNumberStyle;
    }

    public int getRightStart() {
        return this.rightStart;
    }

    public void setRightStart(int rightStart) {
        this.rightStart = rightStart;
    }

    public int getRightEnd() {
        return this.rightEnd;
    }

    public void setRightEnd(int rightEnd) {
        this.rightEnd = rightEnd;
    }

    public String toString() {
        String nodeStr = "0";
        if (this.nodeNumber > 0) {
            nodeStr = String.valueOf(this.nodeNumber);
        } else if (this.getRnodNumber() > 0) {
            nodeStr = String.format("(n%d)", this.getRnodNumber());
        }
        return String.format("%s,%s,%d,%d,%s,%d,%d", new Object[]{nodeStr, this.leftNumberStyle, this.leftStart, this.leftEnd, this.rightNumberStyle, this.rightStart, this.rightEnd});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Numbers)) {
            return false;
        }
        Numbers other = (Numbers)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

