/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.imgfmt.app.net.TableA;

public class TableC {
    private int size;
    private final TableA tabA;
    private final List<RouteRestriction> restrictions = new ArrayList<RouteRestriction>();

    public TableC(TableA tabA) {
        this.tabA = tabA;
    }

    public void write(ImgFileWriter writer, int tablesOffset) {
        if (!this.restrictions.isEmpty()) {
            if (this.size < 256) {
                writer.put((byte)this.size);
            } else {
                writer.putChar((char)this.size);
            }
            for (RouteRestriction restr : this.restrictions) {
                restr.write(writer, tablesOffset);
            }
        }
        if (this.tabA.numRoundaboutArcs() > 0) {
            writer.put((byte)this.tabA.numRoundaboutArcs());
        }
        if (this.tabA.numUnpavedArcs() > 0) {
            writer.put((byte)this.tabA.numUnpavedArcs());
        }
        if (this.tabA.numFerryArcs() > 0) {
            writer.put((byte)this.tabA.numFerryArcs());
        }
    }

    public int addRestriction(RouteRestriction restr) {
        int offset = this.size;
        this.restrictions.add(restr);
        this.size += restr.getSize();
        return offset;
    }

    private byte getOffsetSize() {
        if (this.size < 128) {
            return 1;
        }
        if (this.size < 32768) {
            return 2;
        }
        throw new FormatException("too many restrictions");
    }

    public void propagateSizeBytes() {
        byte b = this.getOffsetSize();
        for (RouteRestriction restr : this.restrictions) {
            restr.setOffsetSize(b);
        }
    }

    public byte getFormat() {
        int format = 0;
        if (this.size > 0) {
            ++format;
            if (this.size > 255) {
                ++format;
            }
        }
        if (this.tabA.numRoundaboutArcs() > 0) {
            format |= 4;
        }
        if (this.tabA.numUnpavedArcs() > 0) {
            format |= 8;
        }
        if (this.tabA.numFerryArcs() > 0) {
            format |= 0x10;
        }
        return (byte)format;
    }
}

