/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class RGNHeader
extends CommonHeader {
    private static final int DEF_LEN = 125;
    public static final int HEADER_LEN = 125;
    private final Section data = new Section();
    private int extTypeAreasOffset;
    private int extTypeAreasSize;
    private int extTypeLinesOffset;
    private int extTypeLinesSize;
    private int extTypePointsOffset;
    private int extTypePointsSize;

    public RGNHeader() {
        super(125, "GARMIN RGN");
        this.data.setPosition(125);
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) throws ReadFailedException {
        this.data.readSectionInfo(reader, false);
        if (this.getHeaderLength() > 29) {
            this.extTypeAreasOffset = reader.getInt();
            this.extTypeAreasSize = reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            this.extTypeLinesOffset = reader.getInt();
            this.extTypeLinesSize = reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            this.extTypePointsOffset = reader.getInt();
            this.extTypePointsSize = reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
            reader.getInt();
        }
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        this.data.writeSectionInfo(writer, false);
        if (this.getHeaderLength() > 29) {
            writer.putInt(this.extTypeAreasOffset);
            writer.putInt(this.extTypeAreasSize);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(this.extTypeLinesOffset);
            writer.putInt(this.extTypeLinesSize);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(this.extTypePointsOffset);
            writer.putInt(this.extTypePointsSize);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
            writer.putInt(0);
        }
    }

    public int getDataOffset() {
        return this.data.getPosition();
    }

    public void setDataSize(int dataSize) {
        this.data.setSize(dataSize);
    }

    public void setExtTypeAreasInfo(int offset, int size) {
        this.extTypeAreasOffset = offset;
        this.extTypeAreasSize = size;
    }

    public void setExtTypeLinesInfo(int offset, int size) {
        this.extTypeLinesOffset = offset;
        this.extTypeLinesSize = size;
    }

    public void setExtTypePointsInfo(int offset, int size) {
        this.extTypePointsOffset = offset;
        this.extTypePointsSize = size;
    }

    public int getExtTypeAreasOffset() {
        return this.extTypeAreasOffset;
    }

    public int getExtTypeAreasSize() {
        return this.extTypeAreasSize;
    }

    public int getExtTypeLinesOffset() {
        return this.extTypeLinesOffset;
    }

    public int getExtTypeLinesSize() {
        return this.extTypeLinesSize;
    }

    public int getExtTypePointsOffset() {
        return this.extTypePointsOffset;
    }

    public int getExtTypePointsSize() {
        return this.extTypePointsSize;
    }
}

